<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SplitBookingResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SplitBookingResponse
 * @subpackage Structs
 */
class SplitBookingResponse extends AbstractResponse
{
    /**
     * The SplitBookingResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\SplitBookingResponse
     */
    public $SplitBookingResult;
    /**
     * The HasForcedSplit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasForcedSplit;
    /**
     * The PnrCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PnrCode;
    /**
     * Constructor method for SplitBookingResponse
     * @uses SplitBookingResponse::setSplitBookingResult()
     * @uses SplitBookingResponse::setHasForcedSplit()
     * @uses SplitBookingResponse::setPnrCode()
     * @param \App|C\StructType\SplitBookingResponse $splitBookingResult
     * @param bool $hasForcedSplit
     * @param string $pnrCode
     */
    public function __construct(\App|C\StructType\SplitBookingResponse $splitBookingResult = null, $hasForcedSplit = null, $pnrCode = null)
    {
        $this
            ->setSplitBookingResult($splitBookingResult)
            ->setHasForcedSplit($hasForcedSplit)
            ->setPnrCode($pnrCode);
    }
    /**
     * Get SplitBookingResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\SplitBookingResponse|null
     */
    public function getSplitBookingResult()
    {
        return isset($this->SplitBookingResult) ? $this->SplitBookingResult : null;
    }
    /**
     * Set SplitBookingResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\SplitBookingResponse $splitBookingResult
     * @return \App|C\StructType\SplitBookingResponse
     */
    public function setSplitBookingResult(\App|C\StructType\SplitBookingResponse $splitBookingResult = null)
    {
        if (is_null($splitBookingResult) || (is_array($splitBookingResult) && empty($splitBookingResult))) {
            unset($this->SplitBookingResult);
        } else {
            $this->SplitBookingResult = $splitBookingResult;
        }
        return $this;
    }
    /**
     * Get HasForcedSplit value
     * @return bool|null
     */
    public function getHasForcedSplit()
    {
        return $this->HasForcedSplit;
    }
    /**
     * Set HasForcedSplit value
     * @param bool $hasForcedSplit
     * @return \App|C\StructType\SplitBookingResponse
     */
    public function setHasForcedSplit($hasForcedSplit = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasForcedSplit) && !is_bool($hasForcedSplit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasForcedSplit, true), gettype($hasForcedSplit)), __LINE__);
        }
        $this->HasForcedSplit = $hasForcedSplit;
        return $this;
    }
    /**
     * Get PnrCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPnrCode()
    {
        return isset($this->PnrCode) ? $this->PnrCode : null;
    }
    /**
     * Set PnrCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pnrCode
     * @return \App|C\StructType\SplitBookingResponse
     */
    public function setPnrCode($pnrCode = null)
    {
        // validation for constraint: string
        if (!is_null($pnrCode) && !is_string($pnrCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pnrCode, true), gettype($pnrCode)), __LINE__);
        }
        if (is_null($pnrCode) || (is_array($pnrCode) && empty($pnrCode))) {
            unset($this->PnrCode);
        } else {
            $this->PnrCode = $pnrCode;
        }
        return $this;
    }
}
