<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormOfPaymentMCOInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FormOfPaymentMCOInfo
 * @subpackage Structs
 */
class FormOfPaymentMCOInfo extends ApiObject
{
    /**
     * The DocumentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentNumber;
    /**
     * The PnrCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PnrCode;
    /**
     * The VoucherData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\GiftVoucherData
     */
    public $VoucherData;
    /**
     * Constructor method for FormOfPaymentMCOInfo
     * @uses FormOfPaymentMCOInfo::setDocumentNumber()
     * @uses FormOfPaymentMCOInfo::setPnrCode()
     * @uses FormOfPaymentMCOInfo::setVoucherData()
     * @param string $documentNumber
     * @param string $pnrCode
     * @param \App|C\StructType\GiftVoucherData $voucherData
     */
    public function __construct($documentNumber = null, $pnrCode = null, \App|C\StructType\GiftVoucherData $voucherData = null)
    {
        $this
            ->setDocumentNumber($documentNumber)
            ->setPnrCode($pnrCode)
            ->setVoucherData($voucherData);
    }
    /**
     * Get DocumentNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return isset($this->DocumentNumber) ? $this->DocumentNumber : null;
    }
    /**
     * Set DocumentNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentNumber
     * @return \App|C\StructType\FormOfPaymentMCOInfo
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentNumber, true), gettype($documentNumber)), __LINE__);
        }
        if (is_null($documentNumber) || (is_array($documentNumber) && empty($documentNumber))) {
            unset($this->DocumentNumber);
        } else {
            $this->DocumentNumber = $documentNumber;
        }
        return $this;
    }
    /**
     * Get PnrCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPnrCode()
    {
        return isset($this->PnrCode) ? $this->PnrCode : null;
    }
    /**
     * Set PnrCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pnrCode
     * @return \App|C\StructType\FormOfPaymentMCOInfo
     */
    public function setPnrCode($pnrCode = null)
    {
        // validation for constraint: string
        if (!is_null($pnrCode) && !is_string($pnrCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pnrCode, true), gettype($pnrCode)), __LINE__);
        }
        if (is_null($pnrCode) || (is_array($pnrCode) && empty($pnrCode))) {
            unset($this->PnrCode);
        } else {
            $this->PnrCode = $pnrCode;
        }
        return $this;
    }
    /**
     * Get VoucherData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\GiftVoucherData|null
     */
    public function getVoucherData()
    {
        return isset($this->VoucherData) ? $this->VoucherData : null;
    }
    /**
     * Set VoucherData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\GiftVoucherData $voucherData
     * @return \App|C\StructType\FormOfPaymentMCOInfo
     */
    public function setVoucherData(\App|C\StructType\GiftVoucherData $voucherData = null)
    {
        if (is_null($voucherData) || (is_array($voucherData) && empty($voucherData))) {
            unset($this->VoucherData);
        } else {
            $this->VoucherData = $voucherData;
        }
        return $this;
    }
}
