<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ECouponBook StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ECouponBook
 * @subpackage Structs
 */
class ECouponBook extends ApiObject
{
    /**
     * The BookCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookCode;
    /**
     * The ECoupons
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfECoupon
     */
    public $ECoupons;
    /**
     * The TypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeCode;
    /**
     * Constructor method for ECouponBook
     * @uses ECouponBook::setBookCode()
     * @uses ECouponBook::setECoupons()
     * @uses ECouponBook::setTypeCode()
     * @param string $bookCode
     * @param \App|C\ArrayType\ArrayOfECoupon $eCoupons
     * @param string $typeCode
     */
    public function __construct($bookCode = null, \App|C\ArrayType\ArrayOfECoupon $eCoupons = null, $typeCode = null)
    {
        $this
            ->setBookCode($bookCode)
            ->setECoupons($eCoupons)
            ->setTypeCode($typeCode);
    }
    /**
     * Get BookCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookCode()
    {
        return isset($this->BookCode) ? $this->BookCode : null;
    }
    /**
     * Set BookCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookCode
     * @return \App|C\StructType\ECouponBook
     */
    public function setBookCode($bookCode = null)
    {
        // validation for constraint: string
        if (!is_null($bookCode) && !is_string($bookCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookCode, true), gettype($bookCode)), __LINE__);
        }
        if (is_null($bookCode) || (is_array($bookCode) && empty($bookCode))) {
            unset($this->BookCode);
        } else {
            $this->BookCode = $bookCode;
        }
        return $this;
    }
    /**
     * Get ECoupons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfECoupon|null
     */
    public function getECoupons()
    {
        return isset($this->ECoupons) ? $this->ECoupons : null;
    }
    /**
     * Set ECoupons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfECoupon $eCoupons
     * @return \App|C\StructType\ECouponBook
     */
    public function setECoupons(\App|C\ArrayType\ArrayOfECoupon $eCoupons = null)
    {
        if (is_null($eCoupons) || (is_array($eCoupons) && empty($eCoupons))) {
            unset($this->ECoupons);
        } else {
            $this->ECoupons = $eCoupons;
        }
        return $this;
    }
    /**
     * Get TypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeCode()
    {
        return isset($this->TypeCode) ? $this->TypeCode : null;
    }
    /**
     * Set TypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeCode
     * @return \App|C\StructType\ECouponBook
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeCode) && !is_string($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeCode, true), gettype($typeCode)), __LINE__);
        }
        if (is_null($typeCode) || (is_array($typeCode) && empty($typeCode))) {
            unset($this->TypeCode);
        } else {
            $this->TypeCode = $typeCode;
        }
        return $this;
    }
}
