<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialServiceDataDocs StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SpecialServiceDataDocs
 * @subpackage Structs
 */
class SpecialServiceDataDocs extends ApiObject
{
    /**
     * The Documents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfDocument
     */
    public $Documents;
    /**
     * The AllowedDocumentTypeCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfstring
     */
    public $AllowedDocumentTypeCodes;
    /**
     * Constructor method for SpecialServiceDataDocs
     * @uses SpecialServiceDataDocs::setDocuments()
     * @uses SpecialServiceDataDocs::setAllowedDocumentTypeCodes()
     * @param \App|C\ArrayType\ArrayOfDocument $documents
     * @param \App|C\ArrayType\ArrayOfstring $allowedDocumentTypeCodes
     */
    public function __construct(\App|C\ArrayType\ArrayOfDocument $documents = null, \App|C\ArrayType\ArrayOfstring $allowedDocumentTypeCodes = null)
    {
        $this
            ->setDocuments($documents)
            ->setAllowedDocumentTypeCodes($allowedDocumentTypeCodes);
    }
    /**
     * Get Documents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfDocument|null
     */
    public function getDocuments()
    {
        return isset($this->Documents) ? $this->Documents : null;
    }
    /**
     * Set Documents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfDocument $documents
     * @return \App|C\StructType\SpecialServiceDataDocs
     */
    public function setDocuments(\App|C\ArrayType\ArrayOfDocument $documents = null)
    {
        if (is_null($documents) || (is_array($documents) && empty($documents))) {
            unset($this->Documents);
        } else {
            $this->Documents = $documents;
        }
        return $this;
    }
    /**
     * Get AllowedDocumentTypeCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfstring|null
     */
    public function getAllowedDocumentTypeCodes()
    {
        return isset($this->AllowedDocumentTypeCodes) ? $this->AllowedDocumentTypeCodes : null;
    }
    /**
     * Set AllowedDocumentTypeCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfstring $allowedDocumentTypeCodes
     * @return \App|C\StructType\SpecialServiceDataDocs
     */
    public function setAllowedDocumentTypeCodes(\App|C\ArrayType\ArrayOfstring $allowedDocumentTypeCodes = null)
    {
        if (is_null($allowedDocumentTypeCodes) || (is_array($allowedDocumentTypeCodes) && empty($allowedDocumentTypeCodes))) {
            unset($this->AllowedDocumentTypeCodes);
        } else {
            $this->AllowedDocumentTypeCodes = $allowedDocumentTypeCodes;
        }
        return $this;
    }
}
