<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PnrMCOReference StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PnrMCOReference
 * @subpackage Structs
 */
class PnrMCOReference extends ApiObject
{
    /**
     * The DocumentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentNumber;
    /**
     * The PnrCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PnrCode;
    /**
     * Constructor method for PnrMCOReference
     * @uses PnrMCOReference::setDocumentNumber()
     * @uses PnrMCOReference::setPnrCode()
     * @param string $documentNumber
     * @param string $pnrCode
     */
    public function __construct($documentNumber = null, $pnrCode = null)
    {
        $this
            ->setDocumentNumber($documentNumber)
            ->setPnrCode($pnrCode);
    }
    /**
     * Get DocumentNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return isset($this->DocumentNumber) ? $this->DocumentNumber : null;
    }
    /**
     * Set DocumentNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentNumber
     * @return \App|C\StructType\PnrMCOReference
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentNumber, true), gettype($documentNumber)), __LINE__);
        }
        if (is_null($documentNumber) || (is_array($documentNumber) && empty($documentNumber))) {
            unset($this->DocumentNumber);
        } else {
            $this->DocumentNumber = $documentNumber;
        }
        return $this;
    }
    /**
     * Get PnrCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPnrCode()
    {
        return isset($this->PnrCode) ? $this->PnrCode : null;
    }
    /**
     * Set PnrCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pnrCode
     * @return \App|C\StructType\PnrMCOReference
     */
    public function setPnrCode($pnrCode = null)
    {
        // validation for constraint: string
        if (!is_null($pnrCode) && !is_string($pnrCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pnrCode, true), gettype($pnrCode)), __LINE__);
        }
        if (is_null($pnrCode) || (is_array($pnrCode) && empty($pnrCode))) {
            unset($this->PnrCode);
        } else {
            $this->PnrCode = $pnrCode;
        }
        return $this;
    }
}
