<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EventInfo
 * @subpackage Structs
 */
class EventInfo extends AbstractStructBase
{
    /**
     * The FormatCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormatCode;
    /**
     * The IsSpecialServiceFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSpecialServiceFilter;
    /**
     * The SpecialServiceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpecialServiceCode;
    /**
     * The SpecialServiceTechnicalType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpecialServiceTechnicalType;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusCode;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Url;
    /**
     * Constructor method for EventInfo
     * @uses EventInfo::setFormatCode()
     * @uses EventInfo::setIsSpecialServiceFilter()
     * @uses EventInfo::setSpecialServiceCode()
     * @uses EventInfo::setSpecialServiceTechnicalType()
     * @uses EventInfo::setStatusCode()
     * @uses EventInfo::setUrl()
     * @param string $formatCode
     * @param bool $isSpecialServiceFilter
     * @param string $specialServiceCode
     * @param string $specialServiceTechnicalType
     * @param string $statusCode
     * @param string $url
     */
    public function __construct($formatCode = null, $isSpecialServiceFilter = null, $specialServiceCode = null, $specialServiceTechnicalType = null, $statusCode = null, $url = null)
    {
        $this
            ->setFormatCode($formatCode)
            ->setIsSpecialServiceFilter($isSpecialServiceFilter)
            ->setSpecialServiceCode($specialServiceCode)
            ->setSpecialServiceTechnicalType($specialServiceTechnicalType)
            ->setStatusCode($statusCode)
            ->setUrl($url);
    }
    /**
     * Get FormatCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormatCode()
    {
        return isset($this->FormatCode) ? $this->FormatCode : null;
    }
    /**
     * Set FormatCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formatCode
     * @return \App|C\StructType\EventInfo
     */
    public function setFormatCode($formatCode = null)
    {
        // validation for constraint: string
        if (!is_null($formatCode) && !is_string($formatCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formatCode, true), gettype($formatCode)), __LINE__);
        }
        if (is_null($formatCode) || (is_array($formatCode) && empty($formatCode))) {
            unset($this->FormatCode);
        } else {
            $this->FormatCode = $formatCode;
        }
        return $this;
    }
    /**
     * Get IsSpecialServiceFilter value
     * @return bool|null
     */
    public function getIsSpecialServiceFilter()
    {
        return $this->IsSpecialServiceFilter;
    }
    /**
     * Set IsSpecialServiceFilter value
     * @param bool $isSpecialServiceFilter
     * @return \App|C\StructType\EventInfo
     */
    public function setIsSpecialServiceFilter($isSpecialServiceFilter = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSpecialServiceFilter) && !is_bool($isSpecialServiceFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSpecialServiceFilter, true), gettype($isSpecialServiceFilter)), __LINE__);
        }
        $this->IsSpecialServiceFilter = $isSpecialServiceFilter;
        return $this;
    }
    /**
     * Get SpecialServiceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecialServiceCode()
    {
        return isset($this->SpecialServiceCode) ? $this->SpecialServiceCode : null;
    }
    /**
     * Set SpecialServiceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specialServiceCode
     * @return \App|C\StructType\EventInfo
     */
    public function setSpecialServiceCode($specialServiceCode = null)
    {
        // validation for constraint: string
        if (!is_null($specialServiceCode) && !is_string($specialServiceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialServiceCode, true), gettype($specialServiceCode)), __LINE__);
        }
        if (is_null($specialServiceCode) || (is_array($specialServiceCode) && empty($specialServiceCode))) {
            unset($this->SpecialServiceCode);
        } else {
            $this->SpecialServiceCode = $specialServiceCode;
        }
        return $this;
    }
    /**
     * Get SpecialServiceTechnicalType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecialServiceTechnicalType()
    {
        return isset($this->SpecialServiceTechnicalType) ? $this->SpecialServiceTechnicalType : null;
    }
    /**
     * Set SpecialServiceTechnicalType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specialServiceTechnicalType
     * @return \App|C\StructType\EventInfo
     */
    public function setSpecialServiceTechnicalType($specialServiceTechnicalType = null)
    {
        // validation for constraint: string
        if (!is_null($specialServiceTechnicalType) && !is_string($specialServiceTechnicalType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialServiceTechnicalType, true), gettype($specialServiceTechnicalType)), __LINE__);
        }
        if (is_null($specialServiceTechnicalType) || (is_array($specialServiceTechnicalType) && empty($specialServiceTechnicalType))) {
            unset($this->SpecialServiceTechnicalType);
        } else {
            $this->SpecialServiceTechnicalType = $specialServiceTechnicalType;
        }
        return $this;
    }
    /**
     * Get StatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusCode()
    {
        return isset($this->StatusCode) ? $this->StatusCode : null;
    }
    /**
     * Set StatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusCode
     * @return \App|C\StructType\EventInfo
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        if (is_null($statusCode) || (is_array($statusCode) && empty($statusCode))) {
            unset($this->StatusCode);
        } else {
            $this->StatusCode = $statusCode;
        }
        return $this;
    }
    /**
     * Get Url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl()
    {
        return isset($this->Url) ? $this->Url : null;
    }
    /**
     * Set Url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url
     * @return \App|C\StructType\EventInfo
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        if (is_null($url) || (is_array($url) && empty($url))) {
            unset($this->Url);
        } else {
            $this->Url = $url;
        }
        return $this;
    }
}
