<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchBookingRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SearchBookingRequest
 * @subpackage Structs
 */
class SearchBookingRequest extends AbstractRequest
{
    /**
     * The CustomerRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomerRef;
    /**
     * The PassengerFirstname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PassengerFirstname;
    /**
     * The PassengerSurname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PassengerSurname;
    /**
     * Constructor method for SearchBookingRequest
     * @uses SearchBookingRequest::setCustomerRef()
     * @uses SearchBookingRequest::setPassengerFirstname()
     * @uses SearchBookingRequest::setPassengerSurname()
     * @param string $customerRef
     * @param string $passengerFirstname
     * @param string $passengerSurname
     */
    public function __construct($customerRef = null, $passengerFirstname = null, $passengerSurname = null)
    {
        $this
            ->setCustomerRef($customerRef)
            ->setPassengerFirstname($passengerFirstname)
            ->setPassengerSurname($passengerSurname);
    }
    /**
     * Get CustomerRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerRef()
    {
        return isset($this->CustomerRef) ? $this->CustomerRef : null;
    }
    /**
     * Set CustomerRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerRef
     * @return \App|C\StructType\SearchBookingRequest
     */
    public function setCustomerRef($customerRef = null)
    {
        // validation for constraint: string
        if (!is_null($customerRef) && !is_string($customerRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerRef, true), gettype($customerRef)), __LINE__);
        }
        if (is_null($customerRef) || (is_array($customerRef) && empty($customerRef))) {
            unset($this->CustomerRef);
        } else {
            $this->CustomerRef = $customerRef;
        }
        return $this;
    }
    /**
     * Get PassengerFirstname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassengerFirstname()
    {
        return isset($this->PassengerFirstname) ? $this->PassengerFirstname : null;
    }
    /**
     * Set PassengerFirstname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passengerFirstname
     * @return \App|C\StructType\SearchBookingRequest
     */
    public function setPassengerFirstname($passengerFirstname = null)
    {
        // validation for constraint: string
        if (!is_null($passengerFirstname) && !is_string($passengerFirstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passengerFirstname, true), gettype($passengerFirstname)), __LINE__);
        }
        if (is_null($passengerFirstname) || (is_array($passengerFirstname) && empty($passengerFirstname))) {
            unset($this->PassengerFirstname);
        } else {
            $this->PassengerFirstname = $passengerFirstname;
        }
        return $this;
    }
    /**
     * Get PassengerSurname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassengerSurname()
    {
        return isset($this->PassengerSurname) ? $this->PassengerSurname : null;
    }
    /**
     * Set PassengerSurname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passengerSurname
     * @return \App|C\StructType\SearchBookingRequest
     */
    public function setPassengerSurname($passengerSurname = null)
    {
        // validation for constraint: string
        if (!is_null($passengerSurname) && !is_string($passengerSurname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passengerSurname, true), gettype($passengerSurname)), __LINE__);
        }
        if (is_null($passengerSurname) || (is_array($passengerSurname) && empty($passengerSurname))) {
            unset($this->PassengerSurname);
        } else {
            $this->PassengerSurname = $passengerSurname;
        }
        return $this;
    }
}
