<?php

namespace App|C\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Uncheck ServiceType
 * @subpackage Services
 */
class Uncheck extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Uncheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\Uncheck $parameters
     * @return \App|C\StructType\UncheckResponse|bool
     */
    public function Uncheck(\App|C\StructType\Uncheck $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Uncheck($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App|C\StructType\UncheckResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
