<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendCustomerRemovalRequestRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SendCustomerRemovalRequestRequest
 * @subpackage Structs
 */
class SendCustomerRemovalRequestRequest extends AbstractRequest
{
    /**
     * The ByLoginAndPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\CustomerPublicReference
     */
    public $ByLoginAndPassword;
    /**
     * The ByReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\CustomerPrivateReference
     */
    public $ByReference;
    /**
     * The RemovalReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RemovalReason;
    /**
     * Constructor method for SendCustomerRemovalRequestRequest
     * @uses SendCustomerRemovalRequestRequest::setByLoginAndPassword()
     * @uses SendCustomerRemovalRequestRequest::setByReference()
     * @uses SendCustomerRemovalRequestRequest::setRemovalReason()
     * @param \App|C\StructType\CustomerPublicReference $byLoginAndPassword
     * @param \App|C\StructType\CustomerPrivateReference $byReference
     * @param string $removalReason
     */
    public function __construct(\App|C\StructType\CustomerPublicReference $byLoginAndPassword = null, \App|C\StructType\CustomerPrivateReference $byReference = null, $removalReason = null)
    {
        $this
            ->setByLoginAndPassword($byLoginAndPassword)
            ->setByReference($byReference)
            ->setRemovalReason($removalReason);
    }
    /**
     * Get ByLoginAndPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\CustomerPublicReference|null
     */
    public function getByLoginAndPassword()
    {
        return isset($this->ByLoginAndPassword) ? $this->ByLoginAndPassword : null;
    }
    /**
     * Set ByLoginAndPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\CustomerPublicReference $byLoginAndPassword
     * @return \App|C\StructType\SendCustomerRemovalRequestRequest
     */
    public function setByLoginAndPassword(\App|C\StructType\CustomerPublicReference $byLoginAndPassword = null)
    {
        if (is_null($byLoginAndPassword) || (is_array($byLoginAndPassword) && empty($byLoginAndPassword))) {
            unset($this->ByLoginAndPassword);
        } else {
            $this->ByLoginAndPassword = $byLoginAndPassword;
        }
        return $this;
    }
    /**
     * Get ByReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\CustomerPrivateReference|null
     */
    public function getByReference()
    {
        return isset($this->ByReference) ? $this->ByReference : null;
    }
    /**
     * Set ByReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\CustomerPrivateReference $byReference
     * @return \App|C\StructType\SendCustomerRemovalRequestRequest
     */
    public function setByReference(\App|C\StructType\CustomerPrivateReference $byReference = null)
    {
        if (is_null($byReference) || (is_array($byReference) && empty($byReference))) {
            unset($this->ByReference);
        } else {
            $this->ByReference = $byReference;
        }
        return $this;
    }
    /**
     * Get RemovalReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemovalReason()
    {
        return isset($this->RemovalReason) ? $this->RemovalReason : null;
    }
    /**
     * Set RemovalReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $removalReason
     * @return \App|C\StructType\SendCustomerRemovalRequestRequest
     */
    public function setRemovalReason($removalReason = null)
    {
        // validation for constraint: string
        if (!is_null($removalReason) && !is_string($removalReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($removalReason, true), gettype($removalReason)), __LINE__);
        }
        if (is_null($removalReason) || (is_array($removalReason) && empty($removalReason))) {
            unset($this->RemovalReason);
        } else {
            $this->RemovalReason = $removalReason;
        }
        return $this;
    }
}
