<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ETCouponDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ETCouponDetails
 * @subpackage Structs
 */
class ETCouponDetails extends ApiObject
{
    /**
     * The IataCouponNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IataCouponNumber;
    /**
     * The InvoluntaryIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoluntaryIndicator;
    /**
     * The PartnerAirlineDesignatorHoldingControl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PartnerAirlineDesignatorHoldingControl;
    /**
     * Constructor method for ETCouponDetails
     * @uses ETCouponDetails::setIataCouponNumber()
     * @uses ETCouponDetails::setInvoluntaryIndicator()
     * @uses ETCouponDetails::setPartnerAirlineDesignatorHoldingControl()
     * @param int $iataCouponNumber
     * @param string $involuntaryIndicator
     * @param string $partnerAirlineDesignatorHoldingControl
     */
    public function __construct($iataCouponNumber = null, $involuntaryIndicator = null, $partnerAirlineDesignatorHoldingControl = null)
    {
        $this
            ->setIataCouponNumber($iataCouponNumber)
            ->setInvoluntaryIndicator($involuntaryIndicator)
            ->setPartnerAirlineDesignatorHoldingControl($partnerAirlineDesignatorHoldingControl);
    }
    /**
     * Get IataCouponNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIataCouponNumber()
    {
        return isset($this->IataCouponNumber) ? $this->IataCouponNumber : null;
    }
    /**
     * Set IataCouponNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $iataCouponNumber
     * @return \App|C\StructType\ETCouponDetails
     */
    public function setIataCouponNumber($iataCouponNumber = null)
    {
        // validation for constraint: int
        if (!is_null($iataCouponNumber) && !(is_int($iataCouponNumber) || ctype_digit($iataCouponNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iataCouponNumber, true), gettype($iataCouponNumber)), __LINE__);
        }
        if (is_null($iataCouponNumber) || (is_array($iataCouponNumber) && empty($iataCouponNumber))) {
            unset($this->IataCouponNumber);
        } else {
            $this->IataCouponNumber = $iataCouponNumber;
        }
        return $this;
    }
    /**
     * Get InvoluntaryIndicator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoluntaryIndicator()
    {
        return isset($this->InvoluntaryIndicator) ? $this->InvoluntaryIndicator : null;
    }
    /**
     * Set InvoluntaryIndicator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $involuntaryIndicator
     * @return \App|C\StructType\ETCouponDetails
     */
    public function setInvoluntaryIndicator($involuntaryIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($involuntaryIndicator) && !is_string($involuntaryIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($involuntaryIndicator, true), gettype($involuntaryIndicator)), __LINE__);
        }
        if (is_null($involuntaryIndicator) || (is_array($involuntaryIndicator) && empty($involuntaryIndicator))) {
            unset($this->InvoluntaryIndicator);
        } else {
            $this->InvoluntaryIndicator = $involuntaryIndicator;
        }
        return $this;
    }
    /**
     * Get PartnerAirlineDesignatorHoldingControl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartnerAirlineDesignatorHoldingControl()
    {
        return isset($this->PartnerAirlineDesignatorHoldingControl) ? $this->PartnerAirlineDesignatorHoldingControl : null;
    }
    /**
     * Set PartnerAirlineDesignatorHoldingControl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partnerAirlineDesignatorHoldingControl
     * @return \App|C\StructType\ETCouponDetails
     */
    public function setPartnerAirlineDesignatorHoldingControl($partnerAirlineDesignatorHoldingControl = null)
    {
        // validation for constraint: string
        if (!is_null($partnerAirlineDesignatorHoldingControl) && !is_string($partnerAirlineDesignatorHoldingControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerAirlineDesignatorHoldingControl, true), gettype($partnerAirlineDesignatorHoldingControl)), __LINE__);
        }
        if (is_null($partnerAirlineDesignatorHoldingControl) || (is_array($partnerAirlineDesignatorHoldingControl) && empty($partnerAirlineDesignatorHoldingControl))) {
            unset($this->PartnerAirlineDesignatorHoldingControl);
        } else {
            $this->PartnerAirlineDesignatorHoldingControl = $partnerAirlineDesignatorHoldingControl;
        }
        return $this;
    }
}
