<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DCSCoupon StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DCSCoupon
 * @subpackage Structs
 */
class DCSCoupon extends ApiObject
{
    /**
     * The RefETCoupon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\DCSCouponElectronicRef
     */
    public $RefETCoupon;
    /**
     * The RefPassenger
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefPassenger;
    /**
     * The RefSegment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefSegment;
    /**
     * The SequenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SequenceNumber;
    /**
     * Constructor method for DCSCoupon
     * @uses DCSCoupon::setRefETCoupon()
     * @uses DCSCoupon::setRefPassenger()
     * @uses DCSCoupon::setRefSegment()
     * @uses DCSCoupon::setSequenceNumber()
     * @param \App|C\StructType\DCSCouponElectronicRef $refETCoupon
     * @param string $refPassenger
     * @param string $refSegment
     * @param int $sequenceNumber
     */
    public function __construct(\App|C\StructType\DCSCouponElectronicRef $refETCoupon = null, $refPassenger = null, $refSegment = null, $sequenceNumber = null)
    {
        $this
            ->setRefETCoupon($refETCoupon)
            ->setRefPassenger($refPassenger)
            ->setRefSegment($refSegment)
            ->setSequenceNumber($sequenceNumber);
    }
    /**
     * Get RefETCoupon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\DCSCouponElectronicRef|null
     */
    public function getRefETCoupon()
    {
        return isset($this->RefETCoupon) ? $this->RefETCoupon : null;
    }
    /**
     * Set RefETCoupon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\DCSCouponElectronicRef $refETCoupon
     * @return \App|C\StructType\DCSCoupon
     */
    public function setRefETCoupon(\App|C\StructType\DCSCouponElectronicRef $refETCoupon = null)
    {
        if (is_null($refETCoupon) || (is_array($refETCoupon) && empty($refETCoupon))) {
            unset($this->RefETCoupon);
        } else {
            $this->RefETCoupon = $refETCoupon;
        }
        return $this;
    }
    /**
     * Get RefPassenger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefPassenger()
    {
        return isset($this->RefPassenger) ? $this->RefPassenger : null;
    }
    /**
     * Set RefPassenger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refPassenger
     * @return \App|C\StructType\DCSCoupon
     */
    public function setRefPassenger($refPassenger = null)
    {
        // validation for constraint: string
        if (!is_null($refPassenger) && !is_string($refPassenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refPassenger, true), gettype($refPassenger)), __LINE__);
        }
        if (is_null($refPassenger) || (is_array($refPassenger) && empty($refPassenger))) {
            unset($this->RefPassenger);
        } else {
            $this->RefPassenger = $refPassenger;
        }
        return $this;
    }
    /**
     * Get RefSegment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefSegment()
    {
        return isset($this->RefSegment) ? $this->RefSegment : null;
    }
    /**
     * Set RefSegment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refSegment
     * @return \App|C\StructType\DCSCoupon
     */
    public function setRefSegment($refSegment = null)
    {
        // validation for constraint: string
        if (!is_null($refSegment) && !is_string($refSegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refSegment, true), gettype($refSegment)), __LINE__);
        }
        if (is_null($refSegment) || (is_array($refSegment) && empty($refSegment))) {
            unset($this->RefSegment);
        } else {
            $this->RefSegment = $refSegment;
        }
        return $this;
    }
    /**
     * Get SequenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSequenceNumber()
    {
        return isset($this->SequenceNumber) ? $this->SequenceNumber : null;
    }
    /**
     * Set SequenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sequenceNumber
     * @return \App|C\StructType\DCSCoupon
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNumber) && !(is_int($sequenceNumber) || ctype_digit($sequenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequenceNumber, true), gettype($sequenceNumber)), __LINE__);
        }
        if (is_null($sequenceNumber) || (is_array($sequenceNumber) && empty($sequenceNumber))) {
            unset($this->SequenceNumber);
        } else {
            $this->SequenceNumber = $sequenceNumber;
        }
        return $this;
    }
}
