<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Customer StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Customer
 * @subpackage Structs
 */
class Customer extends ApiObject
{
    /**
     * The Addresses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfCustomerAddress
     */
    public $Addresses;
    /**
     * The AlertForSalesAgent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlertForSalesAgent;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BirthDate;
    /**
     * The CivilityCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CivilityCode;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comment;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyName;
    /**
     * The CultureName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CultureName;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Currency;
    /**
     * The Documents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfCustomerDocument
     */
    public $Documents;
    /**
     * The Emails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfCustomerEmail
     */
    public $Emails;
    /**
     * The Firstname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Firstname;
    /**
     * The FiscalDocumentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FiscalDocumentNumber;
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Login;
    /**
     * The Middlename
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Middlename;
    /**
     * The Phones
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfCustomerPhone
     */
    public $Phones;
    /**
     * The Ref
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ref;
    /**
     * The Surname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Surname;
    /**
     * The TypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeCode;
    /**
     * The CompanyAdministrativeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyAdministrativeName;
    /**
     * Constructor method for Customer
     * @uses Customer::setAddresses()
     * @uses Customer::setAlertForSalesAgent()
     * @uses Customer::setBirthDate()
     * @uses Customer::setCivilityCode()
     * @uses Customer::setComment()
     * @uses Customer::setCompanyName()
     * @uses Customer::setCultureName()
     * @uses Customer::setCurrency()
     * @uses Customer::setDocuments()
     * @uses Customer::setEmails()
     * @uses Customer::setFirstname()
     * @uses Customer::setFiscalDocumentNumber()
     * @uses Customer::setLogin()
     * @uses Customer::setMiddlename()
     * @uses Customer::setPhones()
     * @uses Customer::setRef()
     * @uses Customer::setSurname()
     * @uses Customer::setTypeCode()
     * @uses Customer::setCompanyAdministrativeName()
     * @param \App|C\ArrayType\ArrayOfCustomerAddress $addresses
     * @param string $alertForSalesAgent
     * @param string $birthDate
     * @param string $civilityCode
     * @param string $comment
     * @param string $companyName
     * @param string $cultureName
     * @param string $currency
     * @param \App|C\ArrayType\ArrayOfCustomerDocument $documents
     * @param \App|C\ArrayType\ArrayOfCustomerEmail $emails
     * @param string $firstname
     * @param string $fiscalDocumentNumber
     * @param string $login
     * @param string $middlename
     * @param \App|C\ArrayType\ArrayOfCustomerPhone $phones
     * @param string $ref
     * @param string $surname
     * @param string $typeCode
     * @param string $companyAdministrativeName
     */
    public function __construct(\App|C\ArrayType\ArrayOfCustomerAddress $addresses = null, $alertForSalesAgent = null, $birthDate = null, $civilityCode = null, $comment = null, $companyName = null, $cultureName = null, $currency = null, \App|C\ArrayType\ArrayOfCustomerDocument $documents = null, \App|C\ArrayType\ArrayOfCustomerEmail $emails = null, $firstname = null, $fiscalDocumentNumber = null, $login = null, $middlename = null, \App|C\ArrayType\ArrayOfCustomerPhone $phones = null, $ref = null, $surname = null, $typeCode = null, $companyAdministrativeName = null)
    {
        $this
            ->setAddresses($addresses)
            ->setAlertForSalesAgent($alertForSalesAgent)
            ->setBirthDate($birthDate)
            ->setCivilityCode($civilityCode)
            ->setComment($comment)
            ->setCompanyName($companyName)
            ->setCultureName($cultureName)
            ->setCurrency($currency)
            ->setDocuments($documents)
            ->setEmails($emails)
            ->setFirstname($firstname)
            ->setFiscalDocumentNumber($fiscalDocumentNumber)
            ->setLogin($login)
            ->setMiddlename($middlename)
            ->setPhones($phones)
            ->setRef($ref)
            ->setSurname($surname)
            ->setTypeCode($typeCode)
            ->setCompanyAdministrativeName($companyAdministrativeName);
    }
    /**
     * Get Addresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfCustomerAddress|null
     */
    public function getAddresses()
    {
        return isset($this->Addresses) ? $this->Addresses : null;
    }
    /**
     * Set Addresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfCustomerAddress $addresses
     * @return \App|C\StructType\Customer
     */
    public function setAddresses(\App|C\ArrayType\ArrayOfCustomerAddress $addresses = null)
    {
        if (is_null($addresses) || (is_array($addresses) && empty($addresses))) {
            unset($this->Addresses);
        } else {
            $this->Addresses = $addresses;
        }
        return $this;
    }
    /**
     * Get AlertForSalesAgent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlertForSalesAgent()
    {
        return isset($this->AlertForSalesAgent) ? $this->AlertForSalesAgent : null;
    }
    /**
     * Set AlertForSalesAgent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alertForSalesAgent
     * @return \App|C\StructType\Customer
     */
    public function setAlertForSalesAgent($alertForSalesAgent = null)
    {
        // validation for constraint: string
        if (!is_null($alertForSalesAgent) && !is_string($alertForSalesAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alertForSalesAgent, true), gettype($alertForSalesAgent)), __LINE__);
        }
        if (is_null($alertForSalesAgent) || (is_array($alertForSalesAgent) && empty($alertForSalesAgent))) {
            unset($this->AlertForSalesAgent);
        } else {
            $this->AlertForSalesAgent = $alertForSalesAgent;
        }
        return $this;
    }
    /**
     * Get BirthDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBirthDate()
    {
        return isset($this->BirthDate) ? $this->BirthDate : null;
    }
    /**
     * Set BirthDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $birthDate
     * @return \App|C\StructType\Customer
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        if (is_null($birthDate) || (is_array($birthDate) && empty($birthDate))) {
            unset($this->BirthDate);
        } else {
            $this->BirthDate = $birthDate;
        }
        return $this;
    }
    /**
     * Get CivilityCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCivilityCode()
    {
        return isset($this->CivilityCode) ? $this->CivilityCode : null;
    }
    /**
     * Set CivilityCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $civilityCode
     * @return \App|C\StructType\Customer
     */
    public function setCivilityCode($civilityCode = null)
    {
        // validation for constraint: string
        if (!is_null($civilityCode) && !is_string($civilityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($civilityCode, true), gettype($civilityCode)), __LINE__);
        }
        if (is_null($civilityCode) || (is_array($civilityCode) && empty($civilityCode))) {
            unset($this->CivilityCode);
        } else {
            $this->CivilityCode = $civilityCode;
        }
        return $this;
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comment
     * @return \App|C\StructType\Customer
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get CompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyName()
    {
        return isset($this->CompanyName) ? $this->CompanyName : null;
    }
    /**
     * Set CompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyName
     * @return \App|C\StructType\Customer
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        if (is_null($companyName) || (is_array($companyName) && empty($companyName))) {
            unset($this->CompanyName);
        } else {
            $this->CompanyName = $companyName;
        }
        return $this;
    }
    /**
     * Get CultureName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCultureName()
    {
        return isset($this->CultureName) ? $this->CultureName : null;
    }
    /**
     * Set CultureName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cultureName
     * @return \App|C\StructType\Customer
     */
    public function setCultureName($cultureName = null)
    {
        // validation for constraint: string
        if (!is_null($cultureName) && !is_string($cultureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureName, true), gettype($cultureName)), __LINE__);
        }
        if (is_null($cultureName) || (is_array($cultureName) && empty($cultureName))) {
            unset($this->CultureName);
        } else {
            $this->CultureName = $cultureName;
        }
        return $this;
    }
    /**
     * Get Currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrency()
    {
        return isset($this->Currency) ? $this->Currency : null;
    }
    /**
     * Set Currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currency
     * @return \App|C\StructType\Customer
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->Currency);
        } else {
            $this->Currency = $currency;
        }
        return $this;
    }
    /**
     * Get Documents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfCustomerDocument|null
     */
    public function getDocuments()
    {
        return isset($this->Documents) ? $this->Documents : null;
    }
    /**
     * Set Documents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfCustomerDocument $documents
     * @return \App|C\StructType\Customer
     */
    public function setDocuments(\App|C\ArrayType\ArrayOfCustomerDocument $documents = null)
    {
        if (is_null($documents) || (is_array($documents) && empty($documents))) {
            unset($this->Documents);
        } else {
            $this->Documents = $documents;
        }
        return $this;
    }
    /**
     * Get Emails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfCustomerEmail|null
     */
    public function getEmails()
    {
        return isset($this->Emails) ? $this->Emails : null;
    }
    /**
     * Set Emails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfCustomerEmail $emails
     * @return \App|C\StructType\Customer
     */
    public function setEmails(\App|C\ArrayType\ArrayOfCustomerEmail $emails = null)
    {
        if (is_null($emails) || (is_array($emails) && empty($emails))) {
            unset($this->Emails);
        } else {
            $this->Emails = $emails;
        }
        return $this;
    }
    /**
     * Get Firstname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstname()
    {
        return isset($this->Firstname) ? $this->Firstname : null;
    }
    /**
     * Set Firstname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstname
     * @return \App|C\StructType\Customer
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        if (is_null($firstname) || (is_array($firstname) && empty($firstname))) {
            unset($this->Firstname);
        } else {
            $this->Firstname = $firstname;
        }
        return $this;
    }
    /**
     * Get FiscalDocumentNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFiscalDocumentNumber()
    {
        return isset($this->FiscalDocumentNumber) ? $this->FiscalDocumentNumber : null;
    }
    /**
     * Set FiscalDocumentNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fiscalDocumentNumber
     * @return \App|C\StructType\Customer
     */
    public function setFiscalDocumentNumber($fiscalDocumentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($fiscalDocumentNumber) && !is_string($fiscalDocumentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fiscalDocumentNumber, true), gettype($fiscalDocumentNumber)), __LINE__);
        }
        if (is_null($fiscalDocumentNumber) || (is_array($fiscalDocumentNumber) && empty($fiscalDocumentNumber))) {
            unset($this->FiscalDocumentNumber);
        } else {
            $this->FiscalDocumentNumber = $fiscalDocumentNumber;
        }
        return $this;
    }
    /**
     * Get Login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogin()
    {
        return isset($this->Login) ? $this->Login : null;
    }
    /**
     * Set Login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $login
     * @return \App|C\StructType\Customer
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        if (is_null($login) || (is_array($login) && empty($login))) {
            unset($this->Login);
        } else {
            $this->Login = $login;
        }
        return $this;
    }
    /**
     * Get Middlename value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMiddlename()
    {
        return isset($this->Middlename) ? $this->Middlename : null;
    }
    /**
     * Set Middlename value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $middlename
     * @return \App|C\StructType\Customer
     */
    public function setMiddlename($middlename = null)
    {
        // validation for constraint: string
        if (!is_null($middlename) && !is_string($middlename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middlename, true), gettype($middlename)), __LINE__);
        }
        if (is_null($middlename) || (is_array($middlename) && empty($middlename))) {
            unset($this->Middlename);
        } else {
            $this->Middlename = $middlename;
        }
        return $this;
    }
    /**
     * Get Phones value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfCustomerPhone|null
     */
    public function getPhones()
    {
        return isset($this->Phones) ? $this->Phones : null;
    }
    /**
     * Set Phones value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfCustomerPhone $phones
     * @return \App|C\StructType\Customer
     */
    public function setPhones(\App|C\ArrayType\ArrayOfCustomerPhone $phones = null)
    {
        if (is_null($phones) || (is_array($phones) && empty($phones))) {
            unset($this->Phones);
        } else {
            $this->Phones = $phones;
        }
        return $this;
    }
    /**
     * Get Ref value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRef()
    {
        return isset($this->Ref) ? $this->Ref : null;
    }
    /**
     * Set Ref value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ref
     * @return \App|C\StructType\Customer
     */
    public function setRef($ref = null)
    {
        // validation for constraint: string
        if (!is_null($ref) && !is_string($ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref, true), gettype($ref)), __LINE__);
        }
        if (is_null($ref) || (is_array($ref) && empty($ref))) {
            unset($this->Ref);
        } else {
            $this->Ref = $ref;
        }
        return $this;
    }
    /**
     * Get Surname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSurname()
    {
        return isset($this->Surname) ? $this->Surname : null;
    }
    /**
     * Set Surname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $surname
     * @return \App|C\StructType\Customer
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        if (is_null($surname) || (is_array($surname) && empty($surname))) {
            unset($this->Surname);
        } else {
            $this->Surname = $surname;
        }
        return $this;
    }
    /**
     * Get TypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeCode()
    {
        return isset($this->TypeCode) ? $this->TypeCode : null;
    }
    /**
     * Set TypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeCode
     * @return \App|C\StructType\Customer
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeCode) && !is_string($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeCode, true), gettype($typeCode)), __LINE__);
        }
        if (is_null($typeCode) || (is_array($typeCode) && empty($typeCode))) {
            unset($this->TypeCode);
        } else {
            $this->TypeCode = $typeCode;
        }
        return $this;
    }
    /**
     * Get CompanyAdministrativeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyAdministrativeName()
    {
        return isset($this->CompanyAdministrativeName) ? $this->CompanyAdministrativeName : null;
    }
    /**
     * Set CompanyAdministrativeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyAdministrativeName
     * @return \App|C\StructType\Customer
     */
    public function setCompanyAdministrativeName($companyAdministrativeName = null)
    {
        // validation for constraint: string
        if (!is_null($companyAdministrativeName) && !is_string($companyAdministrativeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyAdministrativeName, true), gettype($companyAdministrativeName)), __LINE__);
        }
        if (is_null($companyAdministrativeName) || (is_array($companyAdministrativeName) && empty($companyAdministrativeName))) {
            unset($this->CompanyAdministrativeName);
        } else {
            $this->CompanyAdministrativeName = $companyAdministrativeName;
        }
        return $this;
    }
}
