<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingClass StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BookingClass
 * @subpackage Structs
 */
class BookingClass extends ApiObject
{
    /**
     * The CabinClassCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CabinClassCode;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The OperatingCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperatingCode;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Quantity;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusCode;
    /**
     * Constructor method for BookingClass
     * @uses BookingClass::setCabinClassCode()
     * @uses BookingClass::setCode()
     * @uses BookingClass::setOperatingCode()
     * @uses BookingClass::setQuantity()
     * @uses BookingClass::setStatusCode()
     * @param string $cabinClassCode
     * @param string $code
     * @param string $operatingCode
     * @param int $quantity
     * @param string $statusCode
     */
    public function __construct($cabinClassCode = null, $code = null, $operatingCode = null, $quantity = null, $statusCode = null)
    {
        $this
            ->setCabinClassCode($cabinClassCode)
            ->setCode($code)
            ->setOperatingCode($operatingCode)
            ->setQuantity($quantity)
            ->setStatusCode($statusCode);
    }
    /**
     * Get CabinClassCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCabinClassCode()
    {
        return isset($this->CabinClassCode) ? $this->CabinClassCode : null;
    }
    /**
     * Set CabinClassCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cabinClassCode
     * @return \App|C\StructType\BookingClass
     */
    public function setCabinClassCode($cabinClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($cabinClassCode) && !is_string($cabinClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinClassCode, true), gettype($cabinClassCode)), __LINE__);
        }
        if (is_null($cabinClassCode) || (is_array($cabinClassCode) && empty($cabinClassCode))) {
            unset($this->CabinClassCode);
        } else {
            $this->CabinClassCode = $cabinClassCode;
        }
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \App|C\StructType\BookingClass
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get OperatingCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperatingCode()
    {
        return isset($this->OperatingCode) ? $this->OperatingCode : null;
    }
    /**
     * Set OperatingCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operatingCode
     * @return \App|C\StructType\BookingClass
     */
    public function setOperatingCode($operatingCode = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCode) && !is_string($operatingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingCode, true), gettype($operatingCode)), __LINE__);
        }
        if (is_null($operatingCode) || (is_array($operatingCode) && empty($operatingCode))) {
            unset($this->OperatingCode);
        } else {
            $this->OperatingCode = $operatingCode;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \App|C\StructType\BookingClass
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get StatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusCode()
    {
        return isset($this->StatusCode) ? $this->StatusCode : null;
    }
    /**
     * Set StatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusCode
     * @return \App|C\StructType\BookingClass
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        if (is_null($statusCode) || (is_array($statusCode) && empty($statusCode))) {
            unset($this->StatusCode);
        } else {
            $this->StatusCode = $statusCode;
        }
        return $this;
    }
}
