<?php

namespace App|C\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Split ServiceType
 * @subpackage Services
 */
class Split extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SplitBooking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\SplitBooking $parameters
     * @return \App|C\StructType\SplitBookingResponse|bool
     */
    public function SplitBooking(\App|C\StructType\SplitBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SplitBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App|C\StructType\SplitBookingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
