<?php

namespace App|C\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Load ServiceType
 * @subpackage Services
 */
class Load extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LoadBooking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\LoadBooking $parameters
     * @return \App|C\StructType\LoadBookingResponse|bool
     */
    public function LoadBooking(\App|C\StructType\LoadBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadMCOTickets
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\LoadMCOTickets $parameters
     * @return \App|C\StructType\LoadMCOTicketsResponse|bool
     */
    public function LoadMCOTickets(\App|C\StructType\LoadMCOTickets $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadMCOTickets($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadECoupons
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\LoadECoupons $parameters
     * @return \App|C\StructType\LoadECouponsResponse|bool
     */
    public function LoadECoupons(\App|C\StructType\LoadECoupons $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadECoupons($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\LoadCustomer $parameters
     * @return \App|C\StructType\LoadCustomerResponse|bool
     */
    public function LoadCustomer(\App|C\StructType\LoadCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadFrequentFlyerAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\LoadFrequentFlyerAccount $parameters
     * @return \App|C\StructType\LoadFrequentFlyerAccountResponse|bool
     */
    public function LoadFrequentFlyerAccount(\App|C\StructType\LoadFrequentFlyerAccount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadFrequentFlyerAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App|C\StructType\LoadBookingResponse|\App|C\StructType\LoadCustomerResponse|\App|C\StructType\LoadECouponsResponse|\App|C\StructType\LoadFrequentFlyerAccountResponse|\App|C\StructType\LoadMCOTicketsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
