<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoadMCOTicketsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LoadMCOTicketsRequest
 * @subpackage Structs
 */
class LoadMCOTicketsRequest extends AbstractRequest
{
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The CustomerReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\CustomerMCOReference
     */
    public $CustomerReference;
    /**
     * The PnrReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\PnrMCOReference
     */
    public $PnrReference;
    /**
     * The UsableOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UsableOnly;
    /**
     * Constructor method for LoadMCOTicketsRequest
     * @uses LoadMCOTicketsRequest::setCurrencyCode()
     * @uses LoadMCOTicketsRequest::setCustomerReference()
     * @uses LoadMCOTicketsRequest::setPnrReference()
     * @uses LoadMCOTicketsRequest::setUsableOnly()
     * @param string $currencyCode
     * @param \App|C\StructType\CustomerMCOReference $customerReference
     * @param \App|C\StructType\PnrMCOReference $pnrReference
     * @param bool $usableOnly
     */
    public function __construct($currencyCode = null, \App|C\StructType\CustomerMCOReference $customerReference = null, \App|C\StructType\PnrMCOReference $pnrReference = null, $usableOnly = null)
    {
        $this
            ->setCurrencyCode($currencyCode)
            ->setCustomerReference($customerReference)
            ->setPnrReference($pnrReference)
            ->setUsableOnly($usableOnly);
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \App|C\StructType\LoadMCOTicketsRequest
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get CustomerReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\CustomerMCOReference|null
     */
    public function getCustomerReference()
    {
        return isset($this->CustomerReference) ? $this->CustomerReference : null;
    }
    /**
     * Set CustomerReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\CustomerMCOReference $customerReference
     * @return \App|C\StructType\LoadMCOTicketsRequest
     */
    public function setCustomerReference(\App|C\StructType\CustomerMCOReference $customerReference = null)
    {
        if (is_null($customerReference) || (is_array($customerReference) && empty($customerReference))) {
            unset($this->CustomerReference);
        } else {
            $this->CustomerReference = $customerReference;
        }
        return $this;
    }
    /**
     * Get PnrReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\PnrMCOReference|null
     */
    public function getPnrReference()
    {
        return isset($this->PnrReference) ? $this->PnrReference : null;
    }
    /**
     * Set PnrReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\PnrMCOReference $pnrReference
     * @return \App|C\StructType\LoadMCOTicketsRequest
     */
    public function setPnrReference(\App|C\StructType\PnrMCOReference $pnrReference = null)
    {
        if (is_null($pnrReference) || (is_array($pnrReference) && empty($pnrReference))) {
            unset($this->PnrReference);
        } else {
            $this->PnrReference = $pnrReference;
        }
        return $this;
    }
    /**
     * Get UsableOnly value
     * @return bool|null
     */
    public function getUsableOnly()
    {
        return $this->UsableOnly;
    }
    /**
     * Set UsableOnly value
     * @param bool $usableOnly
     * @return \App|C\StructType\LoadMCOTicketsRequest
     */
    public function setUsableOnly($usableOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($usableOnly) && !is_bool($usableOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usableOnly, true), gettype($usableOnly)), __LINE__);
        }
        $this->UsableOnly = $usableOnly;
        return $this;
    }
}
