<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalCollectionAmount StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdditionalCollectionAmount
 * @subpackage Structs
 */
class AdditionalCollectionAmount extends AbstractStructBase
{
    /**
     * The BaseAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $BaseAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TaxAmount;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalAmount;
    /**
     * Constructor method for AdditionalCollectionAmount
     * @uses AdditionalCollectionAmount::setBaseAmount()
     * @uses AdditionalCollectionAmount::setTaxAmount()
     * @uses AdditionalCollectionAmount::setTotalAmount()
     * @param float $baseAmount
     * @param float $taxAmount
     * @param float $totalAmount
     */
    public function __construct($baseAmount = null, $taxAmount = null, $totalAmount = null)
    {
        $this
            ->setBaseAmount($baseAmount)
            ->setTaxAmount($taxAmount)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get BaseAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBaseAmount()
    {
        return isset($this->BaseAmount) ? $this->BaseAmount : null;
    }
    /**
     * Set BaseAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $baseAmount
     * @return \App|C\StructType\AdditionalCollectionAmount
     */
    public function setBaseAmount($baseAmount = null)
    {
        // validation for constraint: float
        if (!is_null($baseAmount) && !(is_float($baseAmount) || is_numeric($baseAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseAmount, true), gettype($baseAmount)), __LINE__);
        }
        if (is_null($baseAmount) || (is_array($baseAmount) && empty($baseAmount))) {
            unset($this->BaseAmount);
        } else {
            $this->BaseAmount = $baseAmount;
        }
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \App|C\StructType\AdditionalCollectionAmount
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param float $totalAmount
     * @return \App|C\StructType\AdditionalCollectionAmount
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->TotalAmount = $totalAmount;
        return $this;
    }
}
