<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormOfPaymentBankTransferInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FormOfPaymentBankTransferInfo
 * @subpackage Structs
 */
class FormOfPaymentBankTransferInfo extends FormOfPaymentBankInfo
{
    /**
     * The BankTransferNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankTransferNumber;
    /**
     * Constructor method for FormOfPaymentBankTransferInfo
     * @uses FormOfPaymentBankTransferInfo::setBankTransferNumber()
     * @param string $bankTransferNumber
     */
    public function __construct($bankTransferNumber = null)
    {
        $this
            ->setBankTransferNumber($bankTransferNumber);
    }
    /**
     * Get BankTransferNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankTransferNumber()
    {
        return isset($this->BankTransferNumber) ? $this->BankTransferNumber : null;
    }
    /**
     * Set BankTransferNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankTransferNumber
     * @return \App|C\StructType\FormOfPaymentBankTransferInfo
     */
    public function setBankTransferNumber($bankTransferNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankTransferNumber) && !is_string($bankTransferNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankTransferNumber, true), gettype($bankTransferNumber)), __LINE__);
        }
        if (is_null($bankTransferNumber) || (is_array($bankTransferNumber) && empty($bankTransferNumber))) {
            unset($this->BankTransferNumber);
        } else {
            $this->BankTransferNumber = $bankTransferNumber;
        }
        return $this;
    }
}
