<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AmountBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AmountBase
 * @subpackage Structs
 */
class AmountBase extends ApiObject
{
    /**
     * The ECoupons
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfECouponAmount
     */
    public $ECoupons;
    /**
     * The MilesAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MilesAmount;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalAmount;
    /**
     * Constructor method for AmountBase
     * @uses AmountBase::setECoupons()
     * @uses AmountBase::setMilesAmount()
     * @uses AmountBase::setTotalAmount()
     * @param \App|C\ArrayType\ArrayOfECouponAmount $eCoupons
     * @param int $milesAmount
     * @param float $totalAmount
     */
    public function __construct(\App|C\ArrayType\ArrayOfECouponAmount $eCoupons = null, $milesAmount = null, $totalAmount = null)
    {
        $this
            ->setECoupons($eCoupons)
            ->setMilesAmount($milesAmount)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get ECoupons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfECouponAmount|null
     */
    public function getECoupons()
    {
        return isset($this->ECoupons) ? $this->ECoupons : null;
    }
    /**
     * Set ECoupons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfECouponAmount $eCoupons
     * @return \App|C\StructType\AmountBase
     */
    public function setECoupons(\App|C\ArrayType\ArrayOfECouponAmount $eCoupons = null)
    {
        if (is_null($eCoupons) || (is_array($eCoupons) && empty($eCoupons))) {
            unset($this->ECoupons);
        } else {
            $this->ECoupons = $eCoupons;
        }
        return $this;
    }
    /**
     * Get MilesAmount value
     * @return int|null
     */
    public function getMilesAmount()
    {
        return $this->MilesAmount;
    }
    /**
     * Set MilesAmount value
     * @param int $milesAmount
     * @return \App|C\StructType\AmountBase
     */
    public function setMilesAmount($milesAmount = null)
    {
        // validation for constraint: int
        if (!is_null($milesAmount) && !(is_int($milesAmount) || ctype_digit($milesAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($milesAmount, true), gettype($milesAmount)), __LINE__);
        }
        $this->MilesAmount = $milesAmount;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param float $totalAmount
     * @return \App|C\StructType\AmountBase
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->TotalAmount = $totalAmount;
        return $this;
    }
}
