<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchServicesRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SearchServicesRequest
 * @subpackage Structs
 */
class SearchServicesRequest extends AbstractRequest
{
    /**
     * The PromoCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PromoCode;
    /**
     * The SaleCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleCurrencyCode;
    /**
     * Constructor method for SearchServicesRequest
     * @uses SearchServicesRequest::setPromoCode()
     * @uses SearchServicesRequest::setSaleCurrencyCode()
     * @param string $promoCode
     * @param string $saleCurrencyCode
     */
    public function __construct($promoCode = null, $saleCurrencyCode = null)
    {
        $this
            ->setPromoCode($promoCode)
            ->setSaleCurrencyCode($saleCurrencyCode);
    }
    /**
     * Get PromoCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromoCode()
    {
        return isset($this->PromoCode) ? $this->PromoCode : null;
    }
    /**
     * Set PromoCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promoCode
     * @return \App|C\StructType\SearchServicesRequest
     */
    public function setPromoCode($promoCode = null)
    {
        // validation for constraint: string
        if (!is_null($promoCode) && !is_string($promoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoCode, true), gettype($promoCode)), __LINE__);
        }
        if (is_null($promoCode) || (is_array($promoCode) && empty($promoCode))) {
            unset($this->PromoCode);
        } else {
            $this->PromoCode = $promoCode;
        }
        return $this;
    }
    /**
     * Get SaleCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleCurrencyCode()
    {
        return isset($this->SaleCurrencyCode) ? $this->SaleCurrencyCode : null;
    }
    /**
     * Set SaleCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleCurrencyCode
     * @return \App|C\StructType\SearchServicesRequest
     */
    public function setSaleCurrencyCode($saleCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleCurrencyCode) && !is_string($saleCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleCurrencyCode, true), gettype($saleCurrencyCode)), __LINE__);
        }
        if (is_null($saleCurrencyCode) || (is_array($saleCurrencyCode) && empty($saleCurrencyCode))) {
            unset($this->SaleCurrencyCode);
        } else {
            $this->SaleCurrencyCode = $saleCurrencyCode;
        }
        return $this;
    }
}
