<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailabilitySettings StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AvailabilitySettings
 * @subpackage Structs
 */
class AvailabilitySettings extends ApiObject
{
    /**
     * The CabinClassCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CabinClassCode;
    /**
     * The IncludeSegmentStops
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeSegmentStops;
    /**
     * The MaxConnectionCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxConnectionCount;
    /**
     * The RealAvailability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RealAvailability;
    /**
     * Constructor method for AvailabilitySettings
     * @uses AvailabilitySettings::setCabinClassCode()
     * @uses AvailabilitySettings::setIncludeSegmentStops()
     * @uses AvailabilitySettings::setMaxConnectionCount()
     * @uses AvailabilitySettings::setRealAvailability()
     * @param string $cabinClassCode
     * @param bool $includeSegmentStops
     * @param int $maxConnectionCount
     * @param bool $realAvailability
     */
    public function __construct($cabinClassCode = null, $includeSegmentStops = null, $maxConnectionCount = null, $realAvailability = null)
    {
        $this
            ->setCabinClassCode($cabinClassCode)
            ->setIncludeSegmentStops($includeSegmentStops)
            ->setMaxConnectionCount($maxConnectionCount)
            ->setRealAvailability($realAvailability);
    }
    /**
     * Get CabinClassCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCabinClassCode()
    {
        return isset($this->CabinClassCode) ? $this->CabinClassCode : null;
    }
    /**
     * Set CabinClassCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cabinClassCode
     * @return \App|C\StructType\AvailabilitySettings
     */
    public function setCabinClassCode($cabinClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($cabinClassCode) && !is_string($cabinClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinClassCode, true), gettype($cabinClassCode)), __LINE__);
        }
        if (is_null($cabinClassCode) || (is_array($cabinClassCode) && empty($cabinClassCode))) {
            unset($this->CabinClassCode);
        } else {
            $this->CabinClassCode = $cabinClassCode;
        }
        return $this;
    }
    /**
     * Get IncludeSegmentStops value
     * @return bool|null
     */
    public function getIncludeSegmentStops()
    {
        return $this->IncludeSegmentStops;
    }
    /**
     * Set IncludeSegmentStops value
     * @param bool $includeSegmentStops
     * @return \App|C\StructType\AvailabilitySettings
     */
    public function setIncludeSegmentStops($includeSegmentStops = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSegmentStops) && !is_bool($includeSegmentStops)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeSegmentStops, true), gettype($includeSegmentStops)), __LINE__);
        }
        $this->IncludeSegmentStops = $includeSegmentStops;
        return $this;
    }
    /**
     * Get MaxConnectionCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxConnectionCount()
    {
        return isset($this->MaxConnectionCount) ? $this->MaxConnectionCount : null;
    }
    /**
     * Set MaxConnectionCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxConnectionCount
     * @return \App|C\StructType\AvailabilitySettings
     */
    public function setMaxConnectionCount($maxConnectionCount = null)
    {
        // validation for constraint: int
        if (!is_null($maxConnectionCount) && !(is_int($maxConnectionCount) || ctype_digit($maxConnectionCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxConnectionCount, true), gettype($maxConnectionCount)), __LINE__);
        }
        if (is_null($maxConnectionCount) || (is_array($maxConnectionCount) && empty($maxConnectionCount))) {
            unset($this->MaxConnectionCount);
        } else {
            $this->MaxConnectionCount = $maxConnectionCount;
        }
        return $this;
    }
    /**
     * Get RealAvailability value
     * @return bool|null
     */
    public function getRealAvailability()
    {
        return $this->RealAvailability;
    }
    /**
     * Set RealAvailability value
     * @param bool $realAvailability
     * @return \App|C\StructType\AvailabilitySettings
     */
    public function setRealAvailability($realAvailability = null)
    {
        // validation for constraint: boolean
        if (!is_null($realAvailability) && !is_bool($realAvailability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($realAvailability, true), gettype($realAvailability)), __LINE__);
        }
        $this->RealAvailability = $realAvailability;
        return $this;
    }
}
