<?php

namespace App|C\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Customer ServiceType
 * @subpackage Services
 */
class Customer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CustomerPasswordPolicies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\CustomerPasswordPolicies $parameters
     * @return \App|C\StructType\CustomerPasswordPoliciesResponse|bool
     */
    public function CustomerPasswordPolicies(\App|C\StructType\CustomerPasswordPolicies $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CustomerPasswordPolicies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App|C\StructType\CustomerPasswordPoliciesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
