<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ElectronicDocumentToCancel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ElectronicDocumentToCancel
 * @subpackage Structs
 */
class ElectronicDocumentToCancel extends ElectronicDocument
{
    /**
     * The CouponOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CouponOrder;
    /**
     * The SaleCurrencyAmountToRefund
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\AmountSummary
     */
    public $SaleCurrencyAmountToRefund;
    /**
     * The TaxesToRefund
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfTicketTax
     */
    public $TaxesToRefund;
    /**
     * Constructor method for ElectronicDocumentToCancel
     * @uses ElectronicDocumentToCancel::setCouponOrder()
     * @uses ElectronicDocumentToCancel::setSaleCurrencyAmountToRefund()
     * @uses ElectronicDocumentToCancel::setTaxesToRefund()
     * @param int $couponOrder
     * @param \App|C\StructType\AmountSummary $saleCurrencyAmountToRefund
     * @param \App|C\ArrayType\ArrayOfTicketTax $taxesToRefund
     */
    public function __construct($couponOrder = null, \App|C\StructType\AmountSummary $saleCurrencyAmountToRefund = null, \App|C\ArrayType\ArrayOfTicketTax $taxesToRefund = null)
    {
        $this
            ->setCouponOrder($couponOrder)
            ->setSaleCurrencyAmountToRefund($saleCurrencyAmountToRefund)
            ->setTaxesToRefund($taxesToRefund);
    }
    /**
     * Get CouponOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCouponOrder()
    {
        return isset($this->CouponOrder) ? $this->CouponOrder : null;
    }
    /**
     * Set CouponOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $couponOrder
     * @return \App|C\StructType\ElectronicDocumentToCancel
     */
    public function setCouponOrder($couponOrder = null)
    {
        // validation for constraint: int
        if (!is_null($couponOrder) && !(is_int($couponOrder) || ctype_digit($couponOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($couponOrder, true), gettype($couponOrder)), __LINE__);
        }
        if (is_null($couponOrder) || (is_array($couponOrder) && empty($couponOrder))) {
            unset($this->CouponOrder);
        } else {
            $this->CouponOrder = $couponOrder;
        }
        return $this;
    }
    /**
     * Get SaleCurrencyAmountToRefund value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\AmountSummary|null
     */
    public function getSaleCurrencyAmountToRefund()
    {
        return isset($this->SaleCurrencyAmountToRefund) ? $this->SaleCurrencyAmountToRefund : null;
    }
    /**
     * Set SaleCurrencyAmountToRefund value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\AmountSummary $saleCurrencyAmountToRefund
     * @return \App|C\StructType\ElectronicDocumentToCancel
     */
    public function setSaleCurrencyAmountToRefund(\App|C\StructType\AmountSummary $saleCurrencyAmountToRefund = null)
    {
        if (is_null($saleCurrencyAmountToRefund) || (is_array($saleCurrencyAmountToRefund) && empty($saleCurrencyAmountToRefund))) {
            unset($this->SaleCurrencyAmountToRefund);
        } else {
            $this->SaleCurrencyAmountToRefund = $saleCurrencyAmountToRefund;
        }
        return $this;
    }
    /**
     * Get TaxesToRefund value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfTicketTax|null
     */
    public function getTaxesToRefund()
    {
        return isset($this->TaxesToRefund) ? $this->TaxesToRefund : null;
    }
    /**
     * Set TaxesToRefund value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfTicketTax $taxesToRefund
     * @return \App|C\StructType\ElectronicDocumentToCancel
     */
    public function setTaxesToRefund(\App|C\ArrayType\ArrayOfTicketTax $taxesToRefund = null)
    {
        if (is_null($taxesToRefund) || (is_array($taxesToRefund) && empty($taxesToRefund))) {
            unset($this->TaxesToRefund);
        } else {
            $this->TaxesToRefund = $taxesToRefund;
        }
        return $this;
    }
}
