<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EMDTicketFareOption StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EMDTicketFareOption
 * @subpackage Structs
 */
class EMDTicketFareOption extends EMDAbstractTicketFare
{
    /**
     * The AllowMultiSelect
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowMultiSelect;
    /**
     * The AppliableRefPassengers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfstring_1
     */
    public $AppliableRefPassengers;
    /**
     * The AppliableRefSegments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfstring_1
     */
    public $AppliableRefSegments;
    /**
     * The IsSpecialServiceUserInput
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSpecialServiceUserInput;
    /**
     * The MaxQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxQuantity;
    /**
     * The IsAmountUserInput
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAmountUserInput;
    /**
     * The CategoryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CategoryCode;
    /**
     * Constructor method for EMDTicketFareOption
     * @uses EMDTicketFareOption::setAllowMultiSelect()
     * @uses EMDTicketFareOption::setAppliableRefPassengers()
     * @uses EMDTicketFareOption::setAppliableRefSegments()
     * @uses EMDTicketFareOption::setIsSpecialServiceUserInput()
     * @uses EMDTicketFareOption::setMaxQuantity()
     * @uses EMDTicketFareOption::setIsAmountUserInput()
     * @uses EMDTicketFareOption::setCategoryCode()
     * @param bool $allowMultiSelect
     * @param \App|C\ArrayType\ArrayOfstring_1 $appliableRefPassengers
     * @param \App|C\ArrayType\ArrayOfstring_1 $appliableRefSegments
     * @param bool $isSpecialServiceUserInput
     * @param int $maxQuantity
     * @param bool $isAmountUserInput
     * @param string $categoryCode
     */
    public function __construct($allowMultiSelect = null, \App|C\ArrayType\ArrayOfstring_1 $appliableRefPassengers = null, \App|C\ArrayType\ArrayOfstring_1 $appliableRefSegments = null, $isSpecialServiceUserInput = null, $maxQuantity = null, $isAmountUserInput = null, $categoryCode = null)
    {
        $this
            ->setAllowMultiSelect($allowMultiSelect)
            ->setAppliableRefPassengers($appliableRefPassengers)
            ->setAppliableRefSegments($appliableRefSegments)
            ->setIsSpecialServiceUserInput($isSpecialServiceUserInput)
            ->setMaxQuantity($maxQuantity)
            ->setIsAmountUserInput($isAmountUserInput)
            ->setCategoryCode($categoryCode);
    }
    /**
     * Get AllowMultiSelect value
     * @return bool|null
     */
    public function getAllowMultiSelect()
    {
        return $this->AllowMultiSelect;
    }
    /**
     * Set AllowMultiSelect value
     * @param bool $allowMultiSelect
     * @return \App|C\StructType\EMDTicketFareOption
     */
    public function setAllowMultiSelect($allowMultiSelect = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowMultiSelect) && !is_bool($allowMultiSelect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowMultiSelect, true), gettype($allowMultiSelect)), __LINE__);
        }
        $this->AllowMultiSelect = $allowMultiSelect;
        return $this;
    }
    /**
     * Get AppliableRefPassengers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfstring_1|null
     */
    public function getAppliableRefPassengers()
    {
        return isset($this->AppliableRefPassengers) ? $this->AppliableRefPassengers : null;
    }
    /**
     * Set AppliableRefPassengers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfstring_1 $appliableRefPassengers
     * @return \App|C\StructType\EMDTicketFareOption
     */
    public function setAppliableRefPassengers(\App|C\ArrayType\ArrayOfstring_1 $appliableRefPassengers = null)
    {
        if (is_null($appliableRefPassengers) || (is_array($appliableRefPassengers) && empty($appliableRefPassengers))) {
            unset($this->AppliableRefPassengers);
        } else {
            $this->AppliableRefPassengers = $appliableRefPassengers;
        }
        return $this;
    }
    /**
     * Get AppliableRefSegments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfstring_1|null
     */
    public function getAppliableRefSegments()
    {
        return isset($this->AppliableRefSegments) ? $this->AppliableRefSegments : null;
    }
    /**
     * Set AppliableRefSegments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfstring_1 $appliableRefSegments
     * @return \App|C\StructType\EMDTicketFareOption
     */
    public function setAppliableRefSegments(\App|C\ArrayType\ArrayOfstring_1 $appliableRefSegments = null)
    {
        if (is_null($appliableRefSegments) || (is_array($appliableRefSegments) && empty($appliableRefSegments))) {
            unset($this->AppliableRefSegments);
        } else {
            $this->AppliableRefSegments = $appliableRefSegments;
        }
        return $this;
    }
    /**
     * Get IsSpecialServiceUserInput value
     * @return bool|null
     */
    public function getIsSpecialServiceUserInput()
    {
        return $this->IsSpecialServiceUserInput;
    }
    /**
     * Set IsSpecialServiceUserInput value
     * @param bool $isSpecialServiceUserInput
     * @return \App|C\StructType\EMDTicketFareOption
     */
    public function setIsSpecialServiceUserInput($isSpecialServiceUserInput = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSpecialServiceUserInput) && !is_bool($isSpecialServiceUserInput)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSpecialServiceUserInput, true), gettype($isSpecialServiceUserInput)), __LINE__);
        }
        $this->IsSpecialServiceUserInput = $isSpecialServiceUserInput;
        return $this;
    }
    /**
     * Get MaxQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxQuantity()
    {
        return isset($this->MaxQuantity) ? $this->MaxQuantity : null;
    }
    /**
     * Set MaxQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxQuantity
     * @return \App|C\StructType\EMDTicketFareOption
     */
    public function setMaxQuantity($maxQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maxQuantity) && !(is_int($maxQuantity) || ctype_digit($maxQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxQuantity, true), gettype($maxQuantity)), __LINE__);
        }
        if (is_null($maxQuantity) || (is_array($maxQuantity) && empty($maxQuantity))) {
            unset($this->MaxQuantity);
        } else {
            $this->MaxQuantity = $maxQuantity;
        }
        return $this;
    }
    /**
     * Get IsAmountUserInput value
     * @return bool|null
     */
    public function getIsAmountUserInput()
    {
        return $this->IsAmountUserInput;
    }
    /**
     * Set IsAmountUserInput value
     * @param bool $isAmountUserInput
     * @return \App|C\StructType\EMDTicketFareOption
     */
    public function setIsAmountUserInput($isAmountUserInput = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAmountUserInput) && !is_bool($isAmountUserInput)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAmountUserInput, true), gettype($isAmountUserInput)), __LINE__);
        }
        $this->IsAmountUserInput = $isAmountUserInput;
        return $this;
    }
    /**
     * Get CategoryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryCode()
    {
        return isset($this->CategoryCode) ? $this->CategoryCode : null;
    }
    /**
     * Set CategoryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryCode
     * @return \App|C\StructType\EMDTicketFareOption
     */
    public function setCategoryCode($categoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($categoryCode) && !is_string($categoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryCode, true), gettype($categoryCode)), __LINE__);
        }
        if (is_null($categoryCode) || (is_array($categoryCode) && empty($categoryCode))) {
            unset($this->CategoryCode);
        } else {
            $this->CategoryCode = $categoryCode;
        }
        return $this;
    }
}
