<?php

namespace App|C\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Flight ServiceType
 * @subpackage Services
 */
class Flight extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FlightStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\FlightStatus $parameters
     * @return \App|C\StructType\FlightStatusResponse|bool
     */
    public function FlightStatus(\App|C\StructType\FlightStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FlightStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App|C\StructType\FlightStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
