<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirCoupon StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AirCoupon
 * @subpackage Structs
 */
class AirCoupon extends ApiObject
{
    /**
     * The BookingClassCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingClassCode;
    /**
     * The CouponOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CouponOrder;
    /**
     * The RefSegment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefSegment;
    /**
     * Constructor method for AirCoupon
     * @uses AirCoupon::setBookingClassCode()
     * @uses AirCoupon::setCouponOrder()
     * @uses AirCoupon::setRefSegment()
     * @param string $bookingClassCode
     * @param int $couponOrder
     * @param string $refSegment
     */
    public function __construct($bookingClassCode = null, $couponOrder = null, $refSegment = null)
    {
        $this
            ->setBookingClassCode($bookingClassCode)
            ->setCouponOrder($couponOrder)
            ->setRefSegment($refSegment);
    }
    /**
     * Get BookingClassCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingClassCode()
    {
        return isset($this->BookingClassCode) ? $this->BookingClassCode : null;
    }
    /**
     * Set BookingClassCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingClassCode
     * @return \App|C\StructType\AirCoupon
     */
    public function setBookingClassCode($bookingClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($bookingClassCode) && !is_string($bookingClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingClassCode, true), gettype($bookingClassCode)), __LINE__);
        }
        if (is_null($bookingClassCode) || (is_array($bookingClassCode) && empty($bookingClassCode))) {
            unset($this->BookingClassCode);
        } else {
            $this->BookingClassCode = $bookingClassCode;
        }
        return $this;
    }
    /**
     * Get CouponOrder value
     * @return int|null
     */
    public function getCouponOrder()
    {
        return $this->CouponOrder;
    }
    /**
     * Set CouponOrder value
     * @param int $couponOrder
     * @return \App|C\StructType\AirCoupon
     */
    public function setCouponOrder($couponOrder = null)
    {
        // validation for constraint: int
        if (!is_null($couponOrder) && !(is_int($couponOrder) || ctype_digit($couponOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($couponOrder, true), gettype($couponOrder)), __LINE__);
        }
        $this->CouponOrder = $couponOrder;
        return $this;
    }
    /**
     * Get RefSegment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefSegment()
    {
        return isset($this->RefSegment) ? $this->RefSegment : null;
    }
    /**
     * Set RefSegment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refSegment
     * @return \App|C\StructType\AirCoupon
     */
    public function setRefSegment($refSegment = null)
    {
        // validation for constraint: string
        if (!is_null($refSegment) && !is_string($refSegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refSegment, true), gettype($refSegment)), __LINE__);
        }
        if (is_null($refSegment) || (is_array($refSegment) && empty($refSegment))) {
            unset($this->RefSegment);
        } else {
            $this->RefSegment = $refSegment;
        }
        return $this;
    }
}
