<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefundConfig StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RefundConfig
 * @subpackage Structs
 */
class RefundConfig extends ApiObject
{
    /**
     * The AllowToRefundAllTaxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowToRefundAllTaxes;
    /**
     * The AllowedToCancelRefundRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowedToCancelRefundRequest;
    /**
     * The AllowedToRefund
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowedToRefund;
    /**
     * The AllowedToRefundTaxOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowedToRefundTaxOnly;
    /**
     * The AllowedToRefuseRefundRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowedToRefuseRefundRequest;
    /**
     * The AllowedToRequestRefund
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowedToRequestRefund;
    /**
     * The DelayHours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DelayHours;
    /**
     * The RefundFopCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfstring
     */
    public $RefundFopCodes;
    /**
     * The RefundFopCodesInAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfstring
     */
    public $RefundFopCodesInAccount;
    /**
     * Constructor method for RefundConfig
     * @uses RefundConfig::setAllowToRefundAllTaxes()
     * @uses RefundConfig::setAllowedToCancelRefundRequest()
     * @uses RefundConfig::setAllowedToRefund()
     * @uses RefundConfig::setAllowedToRefundTaxOnly()
     * @uses RefundConfig::setAllowedToRefuseRefundRequest()
     * @uses RefundConfig::setAllowedToRequestRefund()
     * @uses RefundConfig::setDelayHours()
     * @uses RefundConfig::setRefundFopCodes()
     * @uses RefundConfig::setRefundFopCodesInAccount()
     * @param bool $allowToRefundAllTaxes
     * @param bool $allowedToCancelRefundRequest
     * @param bool $allowedToRefund
     * @param bool $allowedToRefundTaxOnly
     * @param bool $allowedToRefuseRefundRequest
     * @param bool $allowedToRequestRefund
     * @param float $delayHours
     * @param \App|C\ArrayType\ArrayOfstring $refundFopCodes
     * @param \App|C\ArrayType\ArrayOfstring $refundFopCodesInAccount
     */
    public function __construct($allowToRefundAllTaxes = null, $allowedToCancelRefundRequest = null, $allowedToRefund = null, $allowedToRefundTaxOnly = null, $allowedToRefuseRefundRequest = null, $allowedToRequestRefund = null, $delayHours = null, \App|C\ArrayType\ArrayOfstring $refundFopCodes = null, \App|C\ArrayType\ArrayOfstring $refundFopCodesInAccount = null)
    {
        $this
            ->setAllowToRefundAllTaxes($allowToRefundAllTaxes)
            ->setAllowedToCancelRefundRequest($allowedToCancelRefundRequest)
            ->setAllowedToRefund($allowedToRefund)
            ->setAllowedToRefundTaxOnly($allowedToRefundTaxOnly)
            ->setAllowedToRefuseRefundRequest($allowedToRefuseRefundRequest)
            ->setAllowedToRequestRefund($allowedToRequestRefund)
            ->setDelayHours($delayHours)
            ->setRefundFopCodes($refundFopCodes)
            ->setRefundFopCodesInAccount($refundFopCodesInAccount);
    }
    /**
     * Get AllowToRefundAllTaxes value
     * @return bool|null
     */
    public function getAllowToRefundAllTaxes()
    {
        return $this->AllowToRefundAllTaxes;
    }
    /**
     * Set AllowToRefundAllTaxes value
     * @param bool $allowToRefundAllTaxes
     * @return \App|C\StructType\RefundConfig
     */
    public function setAllowToRefundAllTaxes($allowToRefundAllTaxes = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowToRefundAllTaxes) && !is_bool($allowToRefundAllTaxes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowToRefundAllTaxes, true), gettype($allowToRefundAllTaxes)), __LINE__);
        }
        $this->AllowToRefundAllTaxes = $allowToRefundAllTaxes;
        return $this;
    }
    /**
     * Get AllowedToCancelRefundRequest value
     * @return bool|null
     */
    public function getAllowedToCancelRefundRequest()
    {
        return $this->AllowedToCancelRefundRequest;
    }
    /**
     * Set AllowedToCancelRefundRequest value
     * @param bool $allowedToCancelRefundRequest
     * @return \App|C\StructType\RefundConfig
     */
    public function setAllowedToCancelRefundRequest($allowedToCancelRefundRequest = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowedToCancelRefundRequest) && !is_bool($allowedToCancelRefundRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowedToCancelRefundRequest, true), gettype($allowedToCancelRefundRequest)), __LINE__);
        }
        $this->AllowedToCancelRefundRequest = $allowedToCancelRefundRequest;
        return $this;
    }
    /**
     * Get AllowedToRefund value
     * @return bool|null
     */
    public function getAllowedToRefund()
    {
        return $this->AllowedToRefund;
    }
    /**
     * Set AllowedToRefund value
     * @param bool $allowedToRefund
     * @return \App|C\StructType\RefundConfig
     */
    public function setAllowedToRefund($allowedToRefund = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowedToRefund) && !is_bool($allowedToRefund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowedToRefund, true), gettype($allowedToRefund)), __LINE__);
        }
        $this->AllowedToRefund = $allowedToRefund;
        return $this;
    }
    /**
     * Get AllowedToRefundTaxOnly value
     * @return bool|null
     */
    public function getAllowedToRefundTaxOnly()
    {
        return $this->AllowedToRefundTaxOnly;
    }
    /**
     * Set AllowedToRefundTaxOnly value
     * @param bool $allowedToRefundTaxOnly
     * @return \App|C\StructType\RefundConfig
     */
    public function setAllowedToRefundTaxOnly($allowedToRefundTaxOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowedToRefundTaxOnly) && !is_bool($allowedToRefundTaxOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowedToRefundTaxOnly, true), gettype($allowedToRefundTaxOnly)), __LINE__);
        }
        $this->AllowedToRefundTaxOnly = $allowedToRefundTaxOnly;
        return $this;
    }
    /**
     * Get AllowedToRefuseRefundRequest value
     * @return bool|null
     */
    public function getAllowedToRefuseRefundRequest()
    {
        return $this->AllowedToRefuseRefundRequest;
    }
    /**
     * Set AllowedToRefuseRefundRequest value
     * @param bool $allowedToRefuseRefundRequest
     * @return \App|C\StructType\RefundConfig
     */
    public function setAllowedToRefuseRefundRequest($allowedToRefuseRefundRequest = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowedToRefuseRefundRequest) && !is_bool($allowedToRefuseRefundRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowedToRefuseRefundRequest, true), gettype($allowedToRefuseRefundRequest)), __LINE__);
        }
        $this->AllowedToRefuseRefundRequest = $allowedToRefuseRefundRequest;
        return $this;
    }
    /**
     * Get AllowedToRequestRefund value
     * @return bool|null
     */
    public function getAllowedToRequestRefund()
    {
        return $this->AllowedToRequestRefund;
    }
    /**
     * Set AllowedToRequestRefund value
     * @param bool $allowedToRequestRefund
     * @return \App|C\StructType\RefundConfig
     */
    public function setAllowedToRequestRefund($allowedToRequestRefund = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowedToRequestRefund) && !is_bool($allowedToRequestRefund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowedToRequestRefund, true), gettype($allowedToRequestRefund)), __LINE__);
        }
        $this->AllowedToRequestRefund = $allowedToRequestRefund;
        return $this;
    }
    /**
     * Get DelayHours value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDelayHours()
    {
        return isset($this->DelayHours) ? $this->DelayHours : null;
    }
    /**
     * Set DelayHours value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $delayHours
     * @return \App|C\StructType\RefundConfig
     */
    public function setDelayHours($delayHours = null)
    {
        // validation for constraint: float
        if (!is_null($delayHours) && !(is_float($delayHours) || is_numeric($delayHours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($delayHours, true), gettype($delayHours)), __LINE__);
        }
        if (is_null($delayHours) || (is_array($delayHours) && empty($delayHours))) {
            unset($this->DelayHours);
        } else {
            $this->DelayHours = $delayHours;
        }
        return $this;
    }
    /**
     * Get RefundFopCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfstring|null
     */
    public function getRefundFopCodes()
    {
        return isset($this->RefundFopCodes) ? $this->RefundFopCodes : null;
    }
    /**
     * Set RefundFopCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfstring $refundFopCodes
     * @return \App|C\StructType\RefundConfig
     */
    public function setRefundFopCodes(\App|C\ArrayType\ArrayOfstring $refundFopCodes = null)
    {
        if (is_null($refundFopCodes) || (is_array($refundFopCodes) && empty($refundFopCodes))) {
            unset($this->RefundFopCodes);
        } else {
            $this->RefundFopCodes = $refundFopCodes;
        }
        return $this;
    }
    /**
     * Get RefundFopCodesInAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfstring|null
     */
    public function getRefundFopCodesInAccount()
    {
        return isset($this->RefundFopCodesInAccount) ? $this->RefundFopCodesInAccount : null;
    }
    /**
     * Set RefundFopCodesInAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfstring $refundFopCodesInAccount
     * @return \App|C\StructType\RefundConfig
     */
    public function setRefundFopCodesInAccount(\App|C\ArrayType\ArrayOfstring $refundFopCodesInAccount = null)
    {
        if (is_null($refundFopCodesInAccount) || (is_array($refundFopCodesInAccount) && empty($refundFopCodesInAccount))) {
            unset($this->RefundFopCodesInAccount);
        } else {
            $this->RefundFopCodesInAccount = $refundFopCodesInAccount;
        }
        return $this;
    }
}
