<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageReferer StructType
 * @subpackage Structs
 */
class MessageReferer extends AbstractStructBase
{
    /**
     * The CreatedDateGMT
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CreatedDateGMT;
    /**
     * The ApplicationName
     * @var string
     */
    public $ApplicationName;
    /**
     * The ServiceName
     * @var string
     */
    public $ServiceName;
    /**
     * The MethodName
     * @var string
     */
    public $MethodName;
    /**
     * The Url
     * @var string
     */
    public $Url;
    /**
     * Constructor method for MessageReferer
     * @uses MessageReferer::setCreatedDateGMT()
     * @uses MessageReferer::setApplicationName()
     * @uses MessageReferer::setServiceName()
     * @uses MessageReferer::setMethodName()
     * @uses MessageReferer::setUrl()
     * @param string $createdDateGMT
     * @param string $applicationName
     * @param string $serviceName
     * @param string $methodName
     * @param string $url
     */
    public function __construct($createdDateGMT = null, $applicationName = null, $serviceName = null, $methodName = null, $url = null)
    {
        $this
            ->setCreatedDateGMT($createdDateGMT)
            ->setApplicationName($applicationName)
            ->setServiceName($serviceName)
            ->setMethodName($methodName)
            ->setUrl($url);
    }
    /**
     * Get CreatedDateGMT value
     * @return string
     */
    public function getCreatedDateGMT()
    {
        return $this->CreatedDateGMT;
    }
    /**
     * Set CreatedDateGMT value
     * @param string $createdDateGMT
     * @return \App|C\StructType\MessageReferer
     */
    public function setCreatedDateGMT($createdDateGMT = null)
    {
        // validation for constraint: string
        if (!is_null($createdDateGMT) && !is_string($createdDateGMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDateGMT, true), gettype($createdDateGMT)), __LINE__);
        }
        $this->CreatedDateGMT = $createdDateGMT;
        return $this;
    }
    /**
     * Get ApplicationName value
     * @return string|null
     */
    public function getApplicationName()
    {
        return $this->ApplicationName;
    }
    /**
     * Set ApplicationName value
     * @param string $applicationName
     * @return \App|C\StructType\MessageReferer
     */
    public function setApplicationName($applicationName = null)
    {
        // validation for constraint: string
        if (!is_null($applicationName) && !is_string($applicationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationName, true), gettype($applicationName)), __LINE__);
        }
        $this->ApplicationName = $applicationName;
        return $this;
    }
    /**
     * Get ServiceName value
     * @return string|null
     */
    public function getServiceName()
    {
        return $this->ServiceName;
    }
    /**
     * Set ServiceName value
     * @param string $serviceName
     * @return \App|C\StructType\MessageReferer
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceName, true), gettype($serviceName)), __LINE__);
        }
        $this->ServiceName = $serviceName;
        return $this;
    }
    /**
     * Get MethodName value
     * @return string|null
     */
    public function getMethodName()
    {
        return $this->MethodName;
    }
    /**
     * Set MethodName value
     * @param string $methodName
     * @return \App|C\StructType\MessageReferer
     */
    public function setMethodName($methodName = null)
    {
        // validation for constraint: string
        if (!is_null($methodName) && !is_string($methodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodName, true), gettype($methodName)), __LINE__);
        }
        $this->MethodName = $methodName;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \App|C\StructType\MessageReferer
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
}
