<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://bsestarmfdemo.bseindia.com/MFOrderEntry/MFOrder.svc?singleWsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://bsestarmfdemo.bseindia.com/MFOrderEntry/MFOrder.svc?singleWsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \SM\SMClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \SM\ServiceType\SMGet($options);
/**
 * Sample call for getPassword operation/method
 */
if ($get->getPassword(new \SM\StructType\SMGetPassword()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Order ServiceType
 */
$order = new \SM\ServiceType\SMOrder($options);
/**
 * Sample call for OrderEntry operation/method
 */
if ($order->OrderEntry(new \SM\StructType\SMOrderEntry()) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
/**
 * Sample call for orderEntryParam operation/method
 */
if ($order->orderEntryParam(new \SM\StructType\SMOrderEntryParam()) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
/**
 * Samples for Spread ServiceType
 */
$spread = new \SM\ServiceType\SMSpread($options);
/**
 * Sample call for spreadOrderEntry operation/method
 */
if ($spread->spreadOrderEntry(new \SM\StructType\SMSpreadOrderEntry()) !== false) {
    print_r($spread->getResult());
} else {
    print_r($spread->getLastError());
}
/**
 * Sample call for spreadOrderEntryParam operation/method
 */
if ($spread->spreadOrderEntryParam(new \SM\StructType\SMSpreadOrderEntryParam()) !== false) {
    print_r($spread->getResult());
} else {
    print_r($spread->getLastError());
}
/**
 * Samples for Switch ServiceType
 */
$switch = new \SM\ServiceType\SMSwitch($options);
/**
 * Sample call for switchOrderEntry operation/method
 */
if ($switch->switchOrderEntry(new \SM\StructType\SMSwitchOrderEntry()) !== false) {
    print_r($switch->getResult());
} else {
    print_r($switch->getLastError());
}
/**
 * Sample call for switchOrderEntryParam operation/method
 */
if ($switch->switchOrderEntryParam(new \SM\StructType\SMSwitchOrderEntryParam()) !== false) {
    print_r($switch->getResult());
} else {
    print_r($switch->getLastError());
}
/**
 * Samples for Sip ServiceType
 */
$sip = new \SM\ServiceType\SMSip($options);
/**
 * Sample call for sipOrderEntry operation/method
 */
if ($sip->sipOrderEntry(new \SM\StructType\SMSipOrderEntry()) !== false) {
    print_r($sip->getResult());
} else {
    print_r($sip->getLastError());
}
/**
 * Sample call for sipOrderEntryParam operation/method
 */
if ($sip->sipOrderEntryParam(new \SM\StructType\SMSipOrderEntryParam()) !== false) {
    print_r($sip->getResult());
} else {
    print_r($sip->getLastError());
}
/**
 * Samples for Xsip ServiceType
 */
$xsip = new \SM\ServiceType\SMXsip($options);
/**
 * Sample call for xsipOrderEntry operation/method
 */
if ($xsip->xsipOrderEntry(new \SM\StructType\SMXsipOrderEntry()) !== false) {
    print_r($xsip->getResult());
} else {
    print_r($xsip->getLastError());
}
/**
 * Sample call for xsipOrderEntryParam operation/method
 */
if ($xsip->xsipOrderEntryParam(new \SM\StructType\SMXsipOrderEntryParam()) !== false) {
    print_r($xsip->getResult());
} else {
    print_r($xsip->getLastError());
}
