<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEpodsSyncRequest StructType
 * @subpackage Structs
 */
class GetEpodsSyncRequest extends AbstractStructBase
{
    /**
     * The consignmentIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 1
     * @var \StructType\ConsignmentIdentificationType[]
     */
    public $consignmentIdentification;
    /**
     * The actUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $actUserId;
    /**
     * The ePodWithTrackingData
     * @var bool
     */
    public $ePodWithTrackingData;
    /**
     * The ePodConvertedToPDF
     * @var bool
     */
    public $ePodConvertedToPDF;
    /**
     * The responseLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $responseLocale;
    /**
     * The referenceDataList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ReferenceDataListRequestType
     */
    public $referenceDataList;
    /**
     * Constructor method for GetEpodsSyncRequest
     * @uses GetEpodsSyncRequest::setConsignmentIdentification()
     * @uses GetEpodsSyncRequest::setActUserId()
     * @uses GetEpodsSyncRequest::setEPodWithTrackingData()
     * @uses GetEpodsSyncRequest::setEPodConvertedToPDF()
     * @uses GetEpodsSyncRequest::setResponseLocale()
     * @uses GetEpodsSyncRequest::setReferenceDataList()
     * @param \StructType\ConsignmentIdentificationType[] $consignmentIdentification
     * @param string $actUserId
     * @param bool $ePodWithTrackingData
     * @param bool $ePodConvertedToPDF
     * @param string $responseLocale
     * @param \StructType\ReferenceDataListRequestType $referenceDataList
     */
    public function __construct(array $consignmentIdentification = array(), $actUserId = null, $ePodWithTrackingData = null, $ePodConvertedToPDF = null, $responseLocale = null, \StructType\ReferenceDataListRequestType $referenceDataList = null)
    {
        $this
            ->setConsignmentIdentification($consignmentIdentification)
            ->setActUserId($actUserId)
            ->setEPodWithTrackingData($ePodWithTrackingData)
            ->setEPodConvertedToPDF($ePodConvertedToPDF)
            ->setResponseLocale($responseLocale)
            ->setReferenceDataList($referenceDataList);
    }
    /**
     * Get consignmentIdentification value
     * @return \StructType\ConsignmentIdentificationType[]
     */
    public function getConsignmentIdentification()
    {
        return $this->consignmentIdentification;
    }
    /**
     * This method is responsible for validating the values passed to the setConsignmentIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConsignmentIdentification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConsignmentIdentificationForArrayConstraintsFromSetConsignmentIdentification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getEpodsSyncRequestConsignmentIdentificationItem) {
            // validation for constraint: itemType
            if (!$getEpodsSyncRequestConsignmentIdentificationItem instanceof \StructType\ConsignmentIdentificationType) {
                $invalidValues[] = is_object($getEpodsSyncRequestConsignmentIdentificationItem) ? get_class($getEpodsSyncRequestConsignmentIdentificationItem) : sprintf('%s(%s)', gettype($getEpodsSyncRequestConsignmentIdentificationItem), var_export($getEpodsSyncRequestConsignmentIdentificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The consignmentIdentification property can only contain items of type \StructType\ConsignmentIdentificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set consignmentIdentification value
     * @throws \InvalidArgumentException
     * @param \StructType\ConsignmentIdentificationType[] $consignmentIdentification
     * @return \StructType\GetEpodsSyncRequest
     */
    public function setConsignmentIdentification(array $consignmentIdentification = array())
    {
        // validation for constraint: array
        if ('' !== ($consignmentIdentificationArrayErrorMessage = self::validateConsignmentIdentificationForArrayConstraintsFromSetConsignmentIdentification($consignmentIdentification))) {
            throw new \InvalidArgumentException($consignmentIdentificationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($consignmentIdentification) && count($consignmentIdentification) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($consignmentIdentification)), __LINE__);
        }
        $this->consignmentIdentification = $consignmentIdentification;
        return $this;
    }
    /**
     * Add item to consignmentIdentification value
     * @throws \InvalidArgumentException
     * @param \StructType\ConsignmentIdentificationType $item
     * @return \StructType\GetEpodsSyncRequest
     */
    public function addToConsignmentIdentification(\StructType\ConsignmentIdentificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConsignmentIdentificationType) {
            throw new \InvalidArgumentException(sprintf('The consignmentIdentification property can only contain items of type \StructType\ConsignmentIdentificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->consignmentIdentification) && count($this->consignmentIdentification) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->consignmentIdentification)), __LINE__);
        }
        $this->consignmentIdentification[] = $item;
        return $this;
    }
    /**
     * Get actUserId value
     * @return string|null
     */
    public function getActUserId()
    {
        return $this->actUserId;
    }
    /**
     * Set actUserId value
     * @param string $actUserId
     * @return \StructType\GetEpodsSyncRequest
     */
    public function setActUserId($actUserId = null)
    {
        // validation for constraint: string
        if (!is_null($actUserId) && !is_string($actUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actUserId, true), gettype($actUserId)), __LINE__);
        }
        $this->actUserId = $actUserId;
        return $this;
    }
    /**
     * Get ePodWithTrackingData value
     * @return bool|null
     */
    public function getEPodWithTrackingData()
    {
        return $this->ePodWithTrackingData;
    }
    /**
     * Set ePodWithTrackingData value
     * @param bool $ePodWithTrackingData
     * @return \StructType\GetEpodsSyncRequest
     */
    public function setEPodWithTrackingData($ePodWithTrackingData = null)
    {
        // validation for constraint: boolean
        if (!is_null($ePodWithTrackingData) && !is_bool($ePodWithTrackingData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ePodWithTrackingData, true), gettype($ePodWithTrackingData)), __LINE__);
        }
        $this->ePodWithTrackingData = $ePodWithTrackingData;
        return $this;
    }
    /**
     * Get ePodConvertedToPDF value
     * @return bool|null
     */
    public function getEPodConvertedToPDF()
    {
        return $this->ePodConvertedToPDF;
    }
    /**
     * Set ePodConvertedToPDF value
     * @param bool $ePodConvertedToPDF
     * @return \StructType\GetEpodsSyncRequest
     */
    public function setEPodConvertedToPDF($ePodConvertedToPDF = null)
    {
        // validation for constraint: boolean
        if (!is_null($ePodConvertedToPDF) && !is_bool($ePodConvertedToPDF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ePodConvertedToPDF, true), gettype($ePodConvertedToPDF)), __LINE__);
        }
        $this->ePodConvertedToPDF = $ePodConvertedToPDF;
        return $this;
    }
    /**
     * Get responseLocale value
     * @return string|null
     */
    public function getResponseLocale()
    {
        return $this->responseLocale;
    }
    /**
     * Set responseLocale value
     * @param string $responseLocale
     * @return \StructType\GetEpodsSyncRequest
     */
    public function setResponseLocale($responseLocale = null)
    {
        // validation for constraint: string
        if (!is_null($responseLocale) && !is_string($responseLocale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseLocale, true), gettype($responseLocale)), __LINE__);
        }
        $this->responseLocale = $responseLocale;
        return $this;
    }
    /**
     * Get referenceDataList value
     * @return \StructType\ReferenceDataListRequestType|null
     */
    public function getReferenceDataList()
    {
        return $this->referenceDataList;
    }
    /**
     * Set referenceDataList value
     * @param \StructType\ReferenceDataListRequestType $referenceDataList
     * @return \StructType\GetEpodsSyncRequest
     */
    public function setReferenceDataList(\StructType\ReferenceDataListRequestType $referenceDataList = null)
    {
        $this->referenceDataList = $referenceDataList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetEpodsSyncRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
