<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for referenceDataListType StructType
 * @subpackage Structs
 */
class ReferenceDataListType extends AbstractStructBase
{
    /**
     * The referenceData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ReferenceDataType[]
     */
    public $referenceData;
    /**
     * Constructor method for referenceDataListType
     * @uses ReferenceDataListType::setReferenceData()
     * @param \StructType\ReferenceDataType[] $referenceData
     */
    public function __construct(array $referenceData = array())
    {
        $this
            ->setReferenceData($referenceData);
    }
    /**
     * Get referenceData value
     * @return \StructType\ReferenceDataType[]|null
     */
    public function getReferenceData()
    {
        return $this->referenceData;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenceData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenceData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceDataForArrayConstraintsFromSetReferenceData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $referenceDataListTypeReferenceDataItem) {
            // validation for constraint: itemType
            if (!$referenceDataListTypeReferenceDataItem instanceof \StructType\ReferenceDataType) {
                $invalidValues[] = is_object($referenceDataListTypeReferenceDataItem) ? get_class($referenceDataListTypeReferenceDataItem) : sprintf('%s(%s)', gettype($referenceDataListTypeReferenceDataItem), var_export($referenceDataListTypeReferenceDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The referenceData property can only contain items of type \StructType\ReferenceDataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set referenceData value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceDataType[] $referenceData
     * @return \StructType\ReferenceDataListType
     */
    public function setReferenceData(array $referenceData = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceDataArrayErrorMessage = self::validateReferenceDataForArrayConstraintsFromSetReferenceData($referenceData))) {
            throw new \InvalidArgumentException($referenceDataArrayErrorMessage, __LINE__);
        }
        $this->referenceData = $referenceData;
        return $this;
    }
    /**
     * Add item to referenceData value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceDataType $item
     * @return \StructType\ReferenceDataListType
     */
    public function addToReferenceData(\StructType\ReferenceDataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReferenceDataType) {
            throw new \InvalidArgumentException(sprintf('The referenceData property can only contain items of type \StructType\ReferenceDataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->referenceData[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReferenceDataListType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
