<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetConsignmentsByIdentifierResponse StructType
 * @subpackage Structs
 */
class GetConsignmentsByIdentifierResponse extends AbstractStructBase
{
    /**
     * The consignmentIdentification
     * @var \StructType\ConsignmentIdentificationType
     */
    public $consignmentIdentification;
    /**
     * The consignment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1000
     * - minOccurs: 0
     * @var \StructType\ConsignmentType[]
     */
    public $consignment;
    /**
     * Constructor method for GetConsignmentsByIdentifierResponse
     * @uses GetConsignmentsByIdentifierResponse::setConsignmentIdentification()
     * @uses GetConsignmentsByIdentifierResponse::setConsignment()
     * @param \StructType\ConsignmentIdentificationType $consignmentIdentification
     * @param \StructType\ConsignmentType[] $consignment
     */
    public function __construct(\StructType\ConsignmentIdentificationType $consignmentIdentification = null, array $consignment = array())
    {
        $this
            ->setConsignmentIdentification($consignmentIdentification)
            ->setConsignment($consignment);
    }
    /**
     * Get consignmentIdentification value
     * @return \StructType\ConsignmentIdentificationType|null
     */
    public function getConsignmentIdentification()
    {
        return $this->consignmentIdentification;
    }
    /**
     * Set consignmentIdentification value
     * @param \StructType\ConsignmentIdentificationType $consignmentIdentification
     * @return \StructType\GetConsignmentsByIdentifierResponse
     */
    public function setConsignmentIdentification(\StructType\ConsignmentIdentificationType $consignmentIdentification = null)
    {
        $this->consignmentIdentification = $consignmentIdentification;
        return $this;
    }
    /**
     * Get consignment value
     * @return \StructType\ConsignmentType[]|null
     */
    public function getConsignment()
    {
        return $this->consignment;
    }
    /**
     * This method is responsible for validating the values passed to the setConsignment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConsignment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConsignmentForArrayConstraintsFromSetConsignment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getConsignmentsByIdentifierResponseConsignmentItem) {
            // validation for constraint: itemType
            if (!$getConsignmentsByIdentifierResponseConsignmentItem instanceof \StructType\ConsignmentType) {
                $invalidValues[] = is_object($getConsignmentsByIdentifierResponseConsignmentItem) ? get_class($getConsignmentsByIdentifierResponseConsignmentItem) : sprintf('%s(%s)', gettype($getConsignmentsByIdentifierResponseConsignmentItem), var_export($getConsignmentsByIdentifierResponseConsignmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The consignment property can only contain items of type \StructType\ConsignmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set consignment value
     * @throws \InvalidArgumentException
     * @param \StructType\ConsignmentType[] $consignment
     * @return \StructType\GetConsignmentsByIdentifierResponse
     */
    public function setConsignment(array $consignment = array())
    {
        // validation for constraint: array
        if ('' !== ($consignmentArrayErrorMessage = self::validateConsignmentForArrayConstraintsFromSetConsignment($consignment))) {
            throw new \InvalidArgumentException($consignmentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1000)
        if (is_array($consignment) && count($consignment) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1000', count($consignment)), __LINE__);
        }
        $this->consignment = $consignment;
        return $this;
    }
    /**
     * Add item to consignment value
     * @throws \InvalidArgumentException
     * @param \StructType\ConsignmentType $item
     * @return \StructType\GetConsignmentsByIdentifierResponse
     */
    public function addToConsignment(\StructType\ConsignmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConsignmentType) {
            throw new \InvalidArgumentException(sprintf('The consignment property can only contain items of type \StructType\ConsignmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1000)
        if (is_array($this->consignment) && count($this->consignment) >= 1000) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1000', count($this->consignment)), __LINE__);
        }
        $this->consignment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetConsignmentsByIdentifierResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
