<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for referenceDataType StructType
 * @subpackage Structs
 */
class ReferenceDataType extends AbstractStructBase
{
    /**
     * The reference
     * @var string
     */
    public $reference;
    /**
     * The referenceType
     * @var string
     */
    public $referenceType;
    /**
     * The referenceSubType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $referenceSubType;
    /**
     * Constructor method for referenceDataType
     * @uses ReferenceDataType::setReference()
     * @uses ReferenceDataType::setReferenceType()
     * @uses ReferenceDataType::setReferenceSubType()
     * @param string $reference
     * @param string $referenceType
     * @param string $referenceSubType
     */
    public function __construct($reference = null, $referenceType = null, $referenceSubType = null)
    {
        $this
            ->setReference($reference)
            ->setReferenceType($referenceType)
            ->setReferenceSubType($referenceSubType);
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\ReferenceDataType
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get referenceType value
     * @return string|null
     */
    public function getReferenceType()
    {
        return $this->referenceType;
    }
    /**
     * Set referenceType value
     * @uses \EnumType\ReferenceType::valueIsValid()
     * @uses \EnumType\ReferenceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $referenceType
     * @return \StructType\ReferenceDataType
     */
    public function setReferenceType($referenceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReferenceType::valueIsValid($referenceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ReferenceType', is_array($referenceType) ? implode(', ', $referenceType) : var_export($referenceType, true), implode(', ', \EnumType\ReferenceType::getValidValues())), __LINE__);
        }
        $this->referenceType = $referenceType;
        return $this;
    }
    /**
     * Get referenceSubType value
     * @return string|null
     */
    public function getReferenceSubType()
    {
        return $this->referenceSubType;
    }
    /**
     * Set referenceSubType value
     * @param string $referenceSubType
     * @return \StructType\ReferenceDataType
     */
    public function setReferenceSubType($referenceSubType = null)
    {
        // validation for constraint: string
        if (!is_null($referenceSubType) && !is_string($referenceSubType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceSubType, true), gettype($referenceSubType)), __LINE__);
        }
        $this->referenceSubType = $referenceSubType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReferenceDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
