<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packageListType StructType
 * @subpackage Structs
 */
class PackageListType extends AbstractStructBase
{
    /**
     * The packageData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PackageDataType[]
     */
    public $packageData;
    /**
     * Constructor method for packageListType
     * @uses PackageListType::setPackageData()
     * @param \StructType\PackageDataType[] $packageData
     */
    public function __construct(array $packageData = array())
    {
        $this
            ->setPackageData($packageData);
    }
    /**
     * Get packageData value
     * @return \StructType\PackageDataType[]|null
     */
    public function getPackageData()
    {
        return $this->packageData;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageDataForArrayConstraintsFromSetPackageData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageListTypePackageDataItem) {
            // validation for constraint: itemType
            if (!$packageListTypePackageDataItem instanceof \StructType\PackageDataType) {
                $invalidValues[] = is_object($packageListTypePackageDataItem) ? get_class($packageListTypePackageDataItem) : sprintf('%s(%s)', gettype($packageListTypePackageDataItem), var_export($packageListTypePackageDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The packageData property can only contain items of type \StructType\PackageDataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set packageData value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageDataType[] $packageData
     * @return \StructType\PackageListType
     */
    public function setPackageData(array $packageData = array())
    {
        // validation for constraint: array
        if ('' !== ($packageDataArrayErrorMessage = self::validatePackageDataForArrayConstraintsFromSetPackageData($packageData))) {
            throw new \InvalidArgumentException($packageDataArrayErrorMessage, __LINE__);
        }
        $this->packageData = $packageData;
        return $this;
    }
    /**
     * Add item to packageData value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageDataType $item
     * @return \StructType\PackageListType
     */
    public function addToPackageData(\StructType\PackageDataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PackageDataType) {
            throw new \InvalidArgumentException(sprintf('The packageData property can only contain items of type \StructType\PackageDataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->packageData[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PackageListType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
