<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetConsignmentsByReferenceResponse StructType
 * @subpackage Structs
 */
class GetConsignmentsByReferenceResponse extends AbstractStructBase
{
    /**
     * The referenceData
     * @var \StructType\ReferenceDataType
     */
    public $referenceData;
    /**
     * The consignment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1000
     * - minOccurs: 0
     * @var \StructType\ConsignmentType[]
     */
    public $consignment;
    /**
     * Constructor method for GetConsignmentsByReferenceResponse
     * @uses GetConsignmentsByReferenceResponse::setReferenceData()
     * @uses GetConsignmentsByReferenceResponse::setConsignment()
     * @param \StructType\ReferenceDataType $referenceData
     * @param \StructType\ConsignmentType[] $consignment
     */
    public function __construct(\StructType\ReferenceDataType $referenceData = null, array $consignment = array())
    {
        $this
            ->setReferenceData($referenceData)
            ->setConsignment($consignment);
    }
    /**
     * Get referenceData value
     * @return \StructType\ReferenceDataType|null
     */
    public function getReferenceData()
    {
        return $this->referenceData;
    }
    /**
     * Set referenceData value
     * @param \StructType\ReferenceDataType $referenceData
     * @return \StructType\GetConsignmentsByReferenceResponse
     */
    public function setReferenceData(\StructType\ReferenceDataType $referenceData = null)
    {
        $this->referenceData = $referenceData;
        return $this;
    }
    /**
     * Get consignment value
     * @return \StructType\ConsignmentType[]|null
     */
    public function getConsignment()
    {
        return $this->consignment;
    }
    /**
     * This method is responsible for validating the values passed to the setConsignment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConsignment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConsignmentForArrayConstraintsFromSetConsignment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getConsignmentsByReferenceResponseConsignmentItem) {
            // validation for constraint: itemType
            if (!$getConsignmentsByReferenceResponseConsignmentItem instanceof \StructType\ConsignmentType) {
                $invalidValues[] = is_object($getConsignmentsByReferenceResponseConsignmentItem) ? get_class($getConsignmentsByReferenceResponseConsignmentItem) : sprintf('%s(%s)', gettype($getConsignmentsByReferenceResponseConsignmentItem), var_export($getConsignmentsByReferenceResponseConsignmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The consignment property can only contain items of type \StructType\ConsignmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set consignment value
     * @throws \InvalidArgumentException
     * @param \StructType\ConsignmentType[] $consignment
     * @return \StructType\GetConsignmentsByReferenceResponse
     */
    public function setConsignment(array $consignment = array())
    {
        // validation for constraint: array
        if ('' !== ($consignmentArrayErrorMessage = self::validateConsignmentForArrayConstraintsFromSetConsignment($consignment))) {
            throw new \InvalidArgumentException($consignmentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1000)
        if (is_array($consignment) && count($consignment) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1000', count($consignment)), __LINE__);
        }
        $this->consignment = $consignment;
        return $this;
    }
    /**
     * Add item to consignment value
     * @throws \InvalidArgumentException
     * @param \StructType\ConsignmentType $item
     * @return \StructType\GetConsignmentsByReferenceResponse
     */
    public function addToConsignment(\StructType\ConsignmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConsignmentType) {
            throw new \InvalidArgumentException(sprintf('The consignment property can only contain items of type \StructType\ConsignmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1000)
        if (is_array($this->consignment) && count($this->consignment) >= 1000) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1000', count($this->consignment)), __LINE__);
        }
        $this->consignment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetConsignmentsByReferenceResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
