<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ePODSearchType StructType
 * @subpackage Structs
 */
class EPODSearchType extends AbstractStructBase
{
    /**
     * The ePODSearchDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 1
     * @var \StructType\EPODSearchDetailType[]
     */
    public $ePODSearchDetail;
    /**
     * The totalNumberOfShipmentId
     * @var int
     */
    public $totalNumberOfShipmentId;
    /**
     * The totalNumberOfShipmentIdProcessed
     * @var int
     */
    public $totalNumberOfShipmentIdProcessed;
    /**
     * The numberOfShipmentIdWithinResponse
     * @var int
     */
    public $numberOfShipmentIdWithinResponse;
    /**
     * The numberEpodAvailable
     * @var int
     */
    public $numberEpodAvailable;
    /**
     * The numberEpodNotAvailable
     * @var int
     */
    public $numberEpodNotAvailable;
    /**
     * The numberEPodFailure
     * @var int
     */
    public $numberEPodFailure;
    /**
     * The ePODZipFile
     * Meta informations extracted from the WSDL
     * - expectedContentTypes: application/octet-stream
     * @var string
     */
    public $ePODZipFile;
    /**
     * Constructor method for ePODSearchType
     * @uses EPODSearchType::setEPODSearchDetail()
     * @uses EPODSearchType::setTotalNumberOfShipmentId()
     * @uses EPODSearchType::setTotalNumberOfShipmentIdProcessed()
     * @uses EPODSearchType::setNumberOfShipmentIdWithinResponse()
     * @uses EPODSearchType::setNumberEpodAvailable()
     * @uses EPODSearchType::setNumberEpodNotAvailable()
     * @uses EPODSearchType::setNumberEPodFailure()
     * @uses EPODSearchType::setEPODZipFile()
     * @param \StructType\EPODSearchDetailType[] $ePODSearchDetail
     * @param int $totalNumberOfShipmentId
     * @param int $totalNumberOfShipmentIdProcessed
     * @param int $numberOfShipmentIdWithinResponse
     * @param int $numberEpodAvailable
     * @param int $numberEpodNotAvailable
     * @param int $numberEPodFailure
     * @param string $ePODZipFile
     */
    public function __construct(array $ePODSearchDetail = array(), $totalNumberOfShipmentId = null, $totalNumberOfShipmentIdProcessed = null, $numberOfShipmentIdWithinResponse = null, $numberEpodAvailable = null, $numberEpodNotAvailable = null, $numberEPodFailure = null, $ePODZipFile = null)
    {
        $this
            ->setEPODSearchDetail($ePODSearchDetail)
            ->setTotalNumberOfShipmentId($totalNumberOfShipmentId)
            ->setTotalNumberOfShipmentIdProcessed($totalNumberOfShipmentIdProcessed)
            ->setNumberOfShipmentIdWithinResponse($numberOfShipmentIdWithinResponse)
            ->setNumberEpodAvailable($numberEpodAvailable)
            ->setNumberEpodNotAvailable($numberEpodNotAvailable)
            ->setNumberEPodFailure($numberEPodFailure)
            ->setEPODZipFile($ePODZipFile);
    }
    /**
     * Get ePODSearchDetail value
     * @return \StructType\EPODSearchDetailType[]
     */
    public function getEPODSearchDetail()
    {
        return $this->ePODSearchDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setEPODSearchDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEPODSearchDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEPODSearchDetailForArrayConstraintsFromSetEPODSearchDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ePODSearchTypeEPODSearchDetailItem) {
            // validation for constraint: itemType
            if (!$ePODSearchTypeEPODSearchDetailItem instanceof \StructType\EPODSearchDetailType) {
                $invalidValues[] = is_object($ePODSearchTypeEPODSearchDetailItem) ? get_class($ePODSearchTypeEPODSearchDetailItem) : sprintf('%s(%s)', gettype($ePODSearchTypeEPODSearchDetailItem), var_export($ePODSearchTypeEPODSearchDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ePODSearchDetail property can only contain items of type \StructType\EPODSearchDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ePODSearchDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\EPODSearchDetailType[] $ePODSearchDetail
     * @return \StructType\EPODSearchType
     */
    public function setEPODSearchDetail(array $ePODSearchDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($ePODSearchDetailArrayErrorMessage = self::validateEPODSearchDetailForArrayConstraintsFromSetEPODSearchDetail($ePODSearchDetail))) {
            throw new \InvalidArgumentException($ePODSearchDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($ePODSearchDetail) && count($ePODSearchDetail) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($ePODSearchDetail)), __LINE__);
        }
        $this->ePODSearchDetail = $ePODSearchDetail;
        return $this;
    }
    /**
     * Add item to ePODSearchDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\EPODSearchDetailType $item
     * @return \StructType\EPODSearchType
     */
    public function addToEPODSearchDetail(\StructType\EPODSearchDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EPODSearchDetailType) {
            throw new \InvalidArgumentException(sprintf('The ePODSearchDetail property can only contain items of type \StructType\EPODSearchDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->ePODSearchDetail) && count($this->ePODSearchDetail) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->ePODSearchDetail)), __LINE__);
        }
        $this->ePODSearchDetail[] = $item;
        return $this;
    }
    /**
     * Get totalNumberOfShipmentId value
     * @return int|null
     */
    public function getTotalNumberOfShipmentId()
    {
        return $this->totalNumberOfShipmentId;
    }
    /**
     * Set totalNumberOfShipmentId value
     * @param int $totalNumberOfShipmentId
     * @return \StructType\EPODSearchType
     */
    public function setTotalNumberOfShipmentId($totalNumberOfShipmentId = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfShipmentId) && !(is_int($totalNumberOfShipmentId) || ctype_digit($totalNumberOfShipmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalNumberOfShipmentId, true), gettype($totalNumberOfShipmentId)), __LINE__);
        }
        $this->totalNumberOfShipmentId = $totalNumberOfShipmentId;
        return $this;
    }
    /**
     * Get totalNumberOfShipmentIdProcessed value
     * @return int|null
     */
    public function getTotalNumberOfShipmentIdProcessed()
    {
        return $this->totalNumberOfShipmentIdProcessed;
    }
    /**
     * Set totalNumberOfShipmentIdProcessed value
     * @param int $totalNumberOfShipmentIdProcessed
     * @return \StructType\EPODSearchType
     */
    public function setTotalNumberOfShipmentIdProcessed($totalNumberOfShipmentIdProcessed = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfShipmentIdProcessed) && !(is_int($totalNumberOfShipmentIdProcessed) || ctype_digit($totalNumberOfShipmentIdProcessed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalNumberOfShipmentIdProcessed, true), gettype($totalNumberOfShipmentIdProcessed)), __LINE__);
        }
        $this->totalNumberOfShipmentIdProcessed = $totalNumberOfShipmentIdProcessed;
        return $this;
    }
    /**
     * Get numberOfShipmentIdWithinResponse value
     * @return int|null
     */
    public function getNumberOfShipmentIdWithinResponse()
    {
        return $this->numberOfShipmentIdWithinResponse;
    }
    /**
     * Set numberOfShipmentIdWithinResponse value
     * @param int $numberOfShipmentIdWithinResponse
     * @return \StructType\EPODSearchType
     */
    public function setNumberOfShipmentIdWithinResponse($numberOfShipmentIdWithinResponse = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfShipmentIdWithinResponse) && !(is_int($numberOfShipmentIdWithinResponse) || ctype_digit($numberOfShipmentIdWithinResponse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfShipmentIdWithinResponse, true), gettype($numberOfShipmentIdWithinResponse)), __LINE__);
        }
        $this->numberOfShipmentIdWithinResponse = $numberOfShipmentIdWithinResponse;
        return $this;
    }
    /**
     * Get numberEpodAvailable value
     * @return int|null
     */
    public function getNumberEpodAvailable()
    {
        return $this->numberEpodAvailable;
    }
    /**
     * Set numberEpodAvailable value
     * @param int $numberEpodAvailable
     * @return \StructType\EPODSearchType
     */
    public function setNumberEpodAvailable($numberEpodAvailable = null)
    {
        // validation for constraint: int
        if (!is_null($numberEpodAvailable) && !(is_int($numberEpodAvailable) || ctype_digit($numberEpodAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberEpodAvailable, true), gettype($numberEpodAvailable)), __LINE__);
        }
        $this->numberEpodAvailable = $numberEpodAvailable;
        return $this;
    }
    /**
     * Get numberEpodNotAvailable value
     * @return int|null
     */
    public function getNumberEpodNotAvailable()
    {
        return $this->numberEpodNotAvailable;
    }
    /**
     * Set numberEpodNotAvailable value
     * @param int $numberEpodNotAvailable
     * @return \StructType\EPODSearchType
     */
    public function setNumberEpodNotAvailable($numberEpodNotAvailable = null)
    {
        // validation for constraint: int
        if (!is_null($numberEpodNotAvailable) && !(is_int($numberEpodNotAvailable) || ctype_digit($numberEpodNotAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberEpodNotAvailable, true), gettype($numberEpodNotAvailable)), __LINE__);
        }
        $this->numberEpodNotAvailable = $numberEpodNotAvailable;
        return $this;
    }
    /**
     * Get numberEPodFailure value
     * @return int|null
     */
    public function getNumberEPodFailure()
    {
        return $this->numberEPodFailure;
    }
    /**
     * Set numberEPodFailure value
     * @param int $numberEPodFailure
     * @return \StructType\EPODSearchType
     */
    public function setNumberEPodFailure($numberEPodFailure = null)
    {
        // validation for constraint: int
        if (!is_null($numberEPodFailure) && !(is_int($numberEPodFailure) || ctype_digit($numberEPodFailure))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberEPodFailure, true), gettype($numberEPodFailure)), __LINE__);
        }
        $this->numberEPodFailure = $numberEPodFailure;
        return $this;
    }
    /**
     * Get ePODZipFile value
     * @return string|null
     */
    public function getEPODZipFile()
    {
        return $this->ePODZipFile;
    }
    /**
     * Set ePODZipFile value
     * @param string $ePODZipFile
     * @return \StructType\EPODSearchType
     */
    public function setEPODZipFile($ePODZipFile = null)
    {
        // validation for constraint: string
        if (!is_null($ePODZipFile) && !is_string($ePODZipFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ePODZipFile, true), gettype($ePODZipFile)), __LINE__);
        }
        $this->ePODZipFile = $ePODZipFile;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EPODSearchType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
