<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoorraadInfoMagazijnTabV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met voorraadinformatie per magazijn
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class VoorraadInfoMagazijnTabV5 extends AbstractStructBase
{
    /**
     * The voorraadInfoMagazijn
     * Meta informations extracted from the WSDL
     * - documentation: Record met voorraadinformatie per magazijn
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: false
     * @var \VoorraadApiV5\StructType\VoorraadInfoMagazijnRecV5[]
     */
    public $voorraadInfoMagazijn;
    /**
     * Constructor method for VoorraadInfoMagazijnTabV5
     * @uses VoorraadInfoMagazijnTabV5::setVoorraadInfoMagazijn()
     * @param \VoorraadApiV5\StructType\VoorraadInfoMagazijnRecV5[] $voorraadInfoMagazijn
     */
    public function __construct(array $voorraadInfoMagazijn = array())
    {
        $this
            ->setVoorraadInfoMagazijn($voorraadInfoMagazijn);
    }
    /**
     * Get voorraadInfoMagazijn value
     * @return \VoorraadApiV5\StructType\VoorraadInfoMagazijnRecV5[]
     */
    public function getVoorraadInfoMagazijn()
    {
        return $this->voorraadInfoMagazijn;
    }
    /**
     * This method is responsible for validating the values passed to the setVoorraadInfoMagazijn method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVoorraadInfoMagazijn method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVoorraadInfoMagazijnForArrayConstraintsFromSetVoorraadInfoMagazijn(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $voorraadInfoMagazijnTabV5VoorraadInfoMagazijnItem) {
            // validation for constraint: itemType
            if (!$voorraadInfoMagazijnTabV5VoorraadInfoMagazijnItem instanceof \VoorraadApiV5\StructType\VoorraadInfoMagazijnRecV5) {
                $invalidValues[] = is_object($voorraadInfoMagazijnTabV5VoorraadInfoMagazijnItem) ? get_class($voorraadInfoMagazijnTabV5VoorraadInfoMagazijnItem) : sprintf('%s(%s)', gettype($voorraadInfoMagazijnTabV5VoorraadInfoMagazijnItem), var_export($voorraadInfoMagazijnTabV5VoorraadInfoMagazijnItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The voorraadInfoMagazijn property can only contain items of type \VoorraadApiV5\StructType\VoorraadInfoMagazijnRecV5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set voorraadInfoMagazijn value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\VoorraadInfoMagazijnRecV5[] $voorraadInfoMagazijn
     * @return \VoorraadApiV5\StructType\VoorraadInfoMagazijnTabV5
     */
    public function setVoorraadInfoMagazijn(array $voorraadInfoMagazijn = array())
    {
        // validation for constraint: array
        if ('' !== ($voorraadInfoMagazijnArrayErrorMessage = self::validateVoorraadInfoMagazijnForArrayConstraintsFromSetVoorraadInfoMagazijn($voorraadInfoMagazijn))) {
            throw new \InvalidArgumentException($voorraadInfoMagazijnArrayErrorMessage, __LINE__);
        }
        $this->voorraadInfoMagazijn = $voorraadInfoMagazijn;
        return $this;
    }
    /**
     * Add item to voorraadInfoMagazijn value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\VoorraadInfoMagazijnRecV5 $item
     * @return \VoorraadApiV5\StructType\VoorraadInfoMagazijnTabV5
     */
    public function addToVoorraadInfoMagazijn(\VoorraadApiV5\StructType\VoorraadInfoMagazijnRecV5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \VoorraadApiV5\StructType\VoorraadInfoMagazijnRecV5) {
            throw new \InvalidArgumentException(sprintf('The voorraadInfoMagazijn property can only contain items of type \VoorraadApiV5\StructType\VoorraadInfoMagazijnRecV5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->voorraadInfoMagazijn[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\VoorraadInfoMagazijnTabV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
