<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerzendwijzetableV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met beschikbare verzendwijzen
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class VerzendwijzetableV5 extends AbstractStructBase
{
    /**
     * The verzendwijze
     * Meta informations extracted from the WSDL
     * - documentation: VerzendwijzeRec
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \VoorraadApiV5\StructType\VerzendwijzeRecV5[]
     */
    public $verzendwijze;
    /**
     * Constructor method for VerzendwijzetableV5
     * @uses VerzendwijzetableV5::setVerzendwijze()
     * @param \VoorraadApiV5\StructType\VerzendwijzeRecV5[] $verzendwijze
     */
    public function __construct(array $verzendwijze = array())
    {
        $this
            ->setVerzendwijze($verzendwijze);
    }
    /**
     * Get verzendwijze value
     * @return \VoorraadApiV5\StructType\VerzendwijzeRecV5[]|null
     */
    public function getVerzendwijze()
    {
        return $this->verzendwijze;
    }
    /**
     * This method is responsible for validating the values passed to the setVerzendwijze method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVerzendwijze method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVerzendwijzeForArrayConstraintsFromSetVerzendwijze(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $verzendwijzetableV5VerzendwijzeItem) {
            // validation for constraint: itemType
            if (!$verzendwijzetableV5VerzendwijzeItem instanceof \VoorraadApiV5\StructType\VerzendwijzeRecV5) {
                $invalidValues[] = is_object($verzendwijzetableV5VerzendwijzeItem) ? get_class($verzendwijzetableV5VerzendwijzeItem) : sprintf('%s(%s)', gettype($verzendwijzetableV5VerzendwijzeItem), var_export($verzendwijzetableV5VerzendwijzeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The verzendwijze property can only contain items of type \VoorraadApiV5\StructType\VerzendwijzeRecV5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set verzendwijze value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\VerzendwijzeRecV5[] $verzendwijze
     * @return \VoorraadApiV5\StructType\VerzendwijzetableV5
     */
    public function setVerzendwijze(array $verzendwijze = array())
    {
        // validation for constraint: array
        if ('' !== ($verzendwijzeArrayErrorMessage = self::validateVerzendwijzeForArrayConstraintsFromSetVerzendwijze($verzendwijze))) {
            throw new \InvalidArgumentException($verzendwijzeArrayErrorMessage, __LINE__);
        }
        $this->verzendwijze = $verzendwijze;
        return $this;
    }
    /**
     * Add item to verzendwijze value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\VerzendwijzeRecV5 $item
     * @return \VoorraadApiV5\StructType\VerzendwijzetableV5
     */
    public function addToVerzendwijze(\VoorraadApiV5\StructType\VerzendwijzeRecV5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \VoorraadApiV5\StructType\VerzendwijzeRecV5) {
            throw new \InvalidArgumentException(sprintf('The verzendwijze property can only contain items of type \VoorraadApiV5\StructType\VerzendwijzeRecV5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->verzendwijze[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\VerzendwijzetableV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
