<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerzendwijzeRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Verzendwijze
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class VerzendwijzeRecV5 extends AbstractStructBase
{
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - documentation: Code van de verzendwijze
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $code;
    /**
     * The naam
     * Meta informations extracted from the WSDL
     * - documentation: Naam/omschrijving van de verzendwijze
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $naam;
    /**
     * The indicatieStandaard
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie dat dit de standaard verzendwijze is
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $indicatieStandaard;
    /**
     * Constructor method for VerzendwijzeRecV5
     * @uses VerzendwijzeRecV5::setCode()
     * @uses VerzendwijzeRecV5::setNaam()
     * @uses VerzendwijzeRecV5::setIndicatieStandaard()
     * @param string $code
     * @param string $naam
     * @param bool $indicatieStandaard
     */
    public function __construct($code = null, $naam = null, $indicatieStandaard = null)
    {
        $this
            ->setCode($code)
            ->setNaam($naam)
            ->setIndicatieStandaard($indicatieStandaard);
    }
    /**
     * Get code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->code) ? $this->code : null;
    }
    /**
     * Set code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \VoorraadApiV5\StructType\VerzendwijzeRecV5
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($code) && mb_strlen($code) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->code);
        } else {
            $this->code = $code;
        }
        return $this;
    }
    /**
     * Get naam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaam()
    {
        return isset($this->naam) ? $this->naam : null;
    }
    /**
     * Set naam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naam
     * @return \VoorraadApiV5\StructType\VerzendwijzeRecV5
     */
    public function setNaam($naam = null)
    {
        // validation for constraint: string
        if (!is_null($naam) && !is_string($naam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naam, true), gettype($naam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($naam) && mb_strlen($naam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($naam)), __LINE__);
        }
        if (is_null($naam) || (is_array($naam) && empty($naam))) {
            unset($this->naam);
        } else {
            $this->naam = $naam;
        }
        return $this;
    }
    /**
     * Get indicatieStandaard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIndicatieStandaard()
    {
        return isset($this->indicatieStandaard) ? $this->indicatieStandaard : null;
    }
    /**
     * Set indicatieStandaard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $indicatieStandaard
     * @return \VoorraadApiV5\StructType\VerzendwijzeRecV5
     */
    public function setIndicatieStandaard($indicatieStandaard = null)
    {
        // validation for constraint: boolean
        if (!is_null($indicatieStandaard) && !is_bool($indicatieStandaard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($indicatieStandaard, true), gettype($indicatieStandaard)), __LINE__);
        }
        if (is_null($indicatieStandaard) || (is_array($indicatieStandaard) && empty($indicatieStandaard))) {
            unset($this->indicatieStandaard);
        } else {
            $this->indicatieStandaard = $indicatieStandaard;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\VerzendwijzeRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
