<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerkooporderInfoRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Informatie van een verkooporder
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class VerkooporderInfoRecV5 extends AbstractStructBase
{
    /**
     * The orderNummer
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de order
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $orderNummer;
    /**
     * The relatieNummerOntvanger
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van de relatie die de order ontvangt
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatieNummerOntvanger;
    /**
     * The relatieNummerDebiteur
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van de betaler van de order
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatieNummerDebiteur;
    /**
     * The orderDatum
     * Meta informations extracted from the WSDL
     * - documentation: Datum van de order
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $orderDatum;
    /**
     * The orderLeverenNaDatum
     * Meta informations extracted from the WSDL
     * - documentation: Een eventuele afwijkende datum waarna de order geleverd mag worden
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $orderLeverenNaDatum;
    /**
     * The ordersoort
     * Meta informations extracted from the WSDL
     * - documentation: Soort order
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \VoorraadApiV5\StructType\OrdersoortRecV5
     */
    public $ordersoort;
    /**
     * The verzendstop
     * Meta informations extracted from the WSDL
     * - documentation: Geeft aan of de order op verzendstop is gezet (deze wordt niet geleverd, totdat de indicatie uitgezet is)
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var bool
     */
    public $verzendstop;
    /**
     * The betaal
     * Meta informations extracted from the WSDL
     * - documentation: Betalingsinformatie
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \VoorraadApiV5\StructType\BetaalRecV5
     */
    public $betaal;
    /**
     * The orderInDelenLeverbaar
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of de order in delen geleverd mag worden zodra er voorraad van een besteld artikel is, of dat de hele order op voorraad moet zijn voordat hij geleverd wordt
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var bool
     */
    public $orderInDelenLeverbaar;
    /**
     * The referentie
     * Meta informations extracted from the WSDL
     * - documentation: De referentie van de order
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $referentie;
    /**
     * The externeOpmerkingen
     * Meta informations extracted from the WSDL
     * - documentation: Opmerkingen die bij de order zijn geplaatst
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $externeOpmerkingen;
    /**
     * The betaalwijzeKenmerk
     * Meta informations extracted from the WSDL
     * - documentation: Het kenmerk van de betaalwijze, indien de order via iDeal of creditcard betaald is
     * - base: xsd:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $betaalwijzeKenmerk;
    /**
     * The betaalreferentie
     * Meta informations extracted from the WSDL
     * - documentation: Factuurreferentie van de klant
     * - base: xsd:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $betaalreferentie;
    /**
     * The betalingsconditie
     * Meta informations extracted from the WSDL
     * - documentation: Afwijkende betalingsconditie
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\BetalingsconditieRecV5
     */
    public $betalingsconditie;
    /**
     * The verzendwijze
     * Meta informations extracted from the WSDL
     * - documentation: Verzendwijze van de order, indien ingevuld
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\VerzendwijzeRecV5
     */
    public $verzendwijze;
    /**
     * The leverstatusCbTekstKort
     * Meta informations extracted from the WSDL
     * - documentation: Korte omschrijving van de status van de levering door het CB
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $leverstatusCbTekstKort;
    /**
     * The leverstatusCbTekstLang
     * Meta informations extracted from the WSDL
     * - documentation: Uitgebreidere omschrijving van de status van de levering door het CB
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $leverstatusCbTekstLang;
    /**
     * The vrijeVelden
     * Meta informations extracted from the WSDL
     * - documentation: Eventuele vrije velden die bij de order zijn ingevuld
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\VrijeVeldenVrdRecV5
     */
    public $vrijeVelden;
    /**
     * The regels
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\VerkooporderregelInfoTabV5
     */
    public $regels;
    /**
     * Constructor method for VerkooporderInfoRecV5
     * @uses VerkooporderInfoRecV5::setOrderNummer()
     * @uses VerkooporderInfoRecV5::setRelatieNummerOntvanger()
     * @uses VerkooporderInfoRecV5::setRelatieNummerDebiteur()
     * @uses VerkooporderInfoRecV5::setOrderDatum()
     * @uses VerkooporderInfoRecV5::setOrderLeverenNaDatum()
     * @uses VerkooporderInfoRecV5::setOrdersoort()
     * @uses VerkooporderInfoRecV5::setVerzendstop()
     * @uses VerkooporderInfoRecV5::setBetaal()
     * @uses VerkooporderInfoRecV5::setOrderInDelenLeverbaar()
     * @uses VerkooporderInfoRecV5::setReferentie()
     * @uses VerkooporderInfoRecV5::setExterneOpmerkingen()
     * @uses VerkooporderInfoRecV5::setBetaalwijzeKenmerk()
     * @uses VerkooporderInfoRecV5::setBetaalreferentie()
     * @uses VerkooporderInfoRecV5::setBetalingsconditie()
     * @uses VerkooporderInfoRecV5::setVerzendwijze()
     * @uses VerkooporderInfoRecV5::setLeverstatusCbTekstKort()
     * @uses VerkooporderInfoRecV5::setLeverstatusCbTekstLang()
     * @uses VerkooporderInfoRecV5::setVrijeVelden()
     * @uses VerkooporderInfoRecV5::setRegels()
     * @param int $orderNummer
     * @param int $relatieNummerOntvanger
     * @param int $relatieNummerDebiteur
     * @param string $orderDatum
     * @param string $orderLeverenNaDatum
     * @param \VoorraadApiV5\StructType\OrdersoortRecV5 $ordersoort
     * @param bool $verzendstop
     * @param \VoorraadApiV5\StructType\BetaalRecV5 $betaal
     * @param bool $orderInDelenLeverbaar
     * @param string $referentie
     * @param string $externeOpmerkingen
     * @param string $betaalwijzeKenmerk
     * @param string $betaalreferentie
     * @param \VoorraadApiV5\StructType\BetalingsconditieRecV5 $betalingsconditie
     * @param \VoorraadApiV5\StructType\VerzendwijzeRecV5 $verzendwijze
     * @param string $leverstatusCbTekstKort
     * @param string $leverstatusCbTekstLang
     * @param \VoorraadApiV5\StructType\VrijeVeldenVrdRecV5 $vrijeVelden
     * @param \VoorraadApiV5\StructType\VerkooporderregelInfoTabV5 $regels
     */
    public function __construct($orderNummer = null, $relatieNummerOntvanger = null, $relatieNummerDebiteur = null, $orderDatum = null, $orderLeverenNaDatum = null, \VoorraadApiV5\StructType\OrdersoortRecV5 $ordersoort = null, $verzendstop = null, \VoorraadApiV5\StructType\BetaalRecV5 $betaal = null, $orderInDelenLeverbaar = null, $referentie = null, $externeOpmerkingen = null, $betaalwijzeKenmerk = null, $betaalreferentie = null, \VoorraadApiV5\StructType\BetalingsconditieRecV5 $betalingsconditie = null, \VoorraadApiV5\StructType\VerzendwijzeRecV5 $verzendwijze = null, $leverstatusCbTekstKort = null, $leverstatusCbTekstLang = null, \VoorraadApiV5\StructType\VrijeVeldenVrdRecV5 $vrijeVelden = null, \VoorraadApiV5\StructType\VerkooporderregelInfoTabV5 $regels = null)
    {
        $this
            ->setOrderNummer($orderNummer)
            ->setRelatieNummerOntvanger($relatieNummerOntvanger)
            ->setRelatieNummerDebiteur($relatieNummerDebiteur)
            ->setOrderDatum($orderDatum)
            ->setOrderLeverenNaDatum($orderLeverenNaDatum)
            ->setOrdersoort($ordersoort)
            ->setVerzendstop($verzendstop)
            ->setBetaal($betaal)
            ->setOrderInDelenLeverbaar($orderInDelenLeverbaar)
            ->setReferentie($referentie)
            ->setExterneOpmerkingen($externeOpmerkingen)
            ->setBetaalwijzeKenmerk($betaalwijzeKenmerk)
            ->setBetaalreferentie($betaalreferentie)
            ->setBetalingsconditie($betalingsconditie)
            ->setVerzendwijze($verzendwijze)
            ->setLeverstatusCbTekstKort($leverstatusCbTekstKort)
            ->setLeverstatusCbTekstLang($leverstatusCbTekstLang)
            ->setVrijeVelden($vrijeVelden)
            ->setRegels($regels);
    }
    /**
     * Get orderNummer value
     * @return int
     */
    public function getOrderNummer()
    {
        return $this->orderNummer;
    }
    /**
     * Set orderNummer value
     * @param int $orderNummer
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setOrderNummer($orderNummer = null)
    {
        // validation for constraint: int
        if (!is_null($orderNummer) && !(is_int($orderNummer) || ctype_digit($orderNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderNummer, true), gettype($orderNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($orderNummer) && mb_strlen(preg_replace('/(\D)/', '', $orderNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($orderNummer, true), mb_strlen(preg_replace('/(\D)/', '', $orderNummer))), __LINE__);
        }
        $this->orderNummer = $orderNummer;
        return $this;
    }
    /**
     * Get relatieNummerOntvanger value
     * @return int
     */
    public function getRelatieNummerOntvanger()
    {
        return $this->relatieNummerOntvanger;
    }
    /**
     * Set relatieNummerOntvanger value
     * @param int $relatieNummerOntvanger
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setRelatieNummerOntvanger($relatieNummerOntvanger = null)
    {
        // validation for constraint: int
        if (!is_null($relatieNummerOntvanger) && !(is_int($relatieNummerOntvanger) || ctype_digit($relatieNummerOntvanger))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieNummerOntvanger, true), gettype($relatieNummerOntvanger)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieNummerOntvanger) && mb_strlen(preg_replace('/(\D)/', '', $relatieNummerOntvanger)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieNummerOntvanger, true), mb_strlen(preg_replace('/(\D)/', '', $relatieNummerOntvanger))), __LINE__);
        }
        $this->relatieNummerOntvanger = $relatieNummerOntvanger;
        return $this;
    }
    /**
     * Get relatieNummerDebiteur value
     * @return int
     */
    public function getRelatieNummerDebiteur()
    {
        return $this->relatieNummerDebiteur;
    }
    /**
     * Set relatieNummerDebiteur value
     * @param int $relatieNummerDebiteur
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setRelatieNummerDebiteur($relatieNummerDebiteur = null)
    {
        // validation for constraint: int
        if (!is_null($relatieNummerDebiteur) && !(is_int($relatieNummerDebiteur) || ctype_digit($relatieNummerDebiteur))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieNummerDebiteur, true), gettype($relatieNummerDebiteur)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieNummerDebiteur) && mb_strlen(preg_replace('/(\D)/', '', $relatieNummerDebiteur)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieNummerDebiteur, true), mb_strlen(preg_replace('/(\D)/', '', $relatieNummerDebiteur))), __LINE__);
        }
        $this->relatieNummerDebiteur = $relatieNummerDebiteur;
        return $this;
    }
    /**
     * Get orderDatum value
     * @return string
     */
    public function getOrderDatum()
    {
        return $this->orderDatum;
    }
    /**
     * Set orderDatum value
     * @param string $orderDatum
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setOrderDatum($orderDatum = null)
    {
        // validation for constraint: string
        if (!is_null($orderDatum) && !is_string($orderDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderDatum, true), gettype($orderDatum)), __LINE__);
        }
        $this->orderDatum = $orderDatum;
        return $this;
    }
    /**
     * Get orderLeverenNaDatum value
     * @return string
     */
    public function getOrderLeverenNaDatum()
    {
        return $this->orderLeverenNaDatum;
    }
    /**
     * Set orderLeverenNaDatum value
     * @param string $orderLeverenNaDatum
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setOrderLeverenNaDatum($orderLeverenNaDatum = null)
    {
        // validation for constraint: string
        if (!is_null($orderLeverenNaDatum) && !is_string($orderLeverenNaDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderLeverenNaDatum, true), gettype($orderLeverenNaDatum)), __LINE__);
        }
        $this->orderLeverenNaDatum = $orderLeverenNaDatum;
        return $this;
    }
    /**
     * Get ordersoort value
     * @return \VoorraadApiV5\StructType\OrdersoortRecV5
     */
    public function getOrdersoort()
    {
        return $this->ordersoort;
    }
    /**
     * Set ordersoort value
     * @param \VoorraadApiV5\StructType\OrdersoortRecV5 $ordersoort
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setOrdersoort(\VoorraadApiV5\StructType\OrdersoortRecV5 $ordersoort = null)
    {
        $this->ordersoort = $ordersoort;
        return $this;
    }
    /**
     * Get verzendstop value
     * @return bool
     */
    public function getVerzendstop()
    {
        return $this->verzendstop;
    }
    /**
     * Set verzendstop value
     * @param bool $verzendstop
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setVerzendstop($verzendstop = null)
    {
        // validation for constraint: boolean
        if (!is_null($verzendstop) && !is_bool($verzendstop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verzendstop, true), gettype($verzendstop)), __LINE__);
        }
        $this->verzendstop = $verzendstop;
        return $this;
    }
    /**
     * Get betaal value
     * @return \VoorraadApiV5\StructType\BetaalRecV5
     */
    public function getBetaal()
    {
        return $this->betaal;
    }
    /**
     * Set betaal value
     * @param \VoorraadApiV5\StructType\BetaalRecV5 $betaal
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setBetaal(\VoorraadApiV5\StructType\BetaalRecV5 $betaal = null)
    {
        $this->betaal = $betaal;
        return $this;
    }
    /**
     * Get orderInDelenLeverbaar value
     * @return bool
     */
    public function getOrderInDelenLeverbaar()
    {
        return $this->orderInDelenLeverbaar;
    }
    /**
     * Set orderInDelenLeverbaar value
     * @param bool $orderInDelenLeverbaar
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setOrderInDelenLeverbaar($orderInDelenLeverbaar = null)
    {
        // validation for constraint: boolean
        if (!is_null($orderInDelenLeverbaar) && !is_bool($orderInDelenLeverbaar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($orderInDelenLeverbaar, true), gettype($orderInDelenLeverbaar)), __LINE__);
        }
        $this->orderInDelenLeverbaar = $orderInDelenLeverbaar;
        return $this;
    }
    /**
     * Get referentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferentie()
    {
        return isset($this->referentie) ? $this->referentie : null;
    }
    /**
     * Set referentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referentie
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setReferentie($referentie = null)
    {
        // validation for constraint: string
        if (!is_null($referentie) && !is_string($referentie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referentie, true), gettype($referentie)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($referentie) && mb_strlen($referentie) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($referentie)), __LINE__);
        }
        if (is_null($referentie) || (is_array($referentie) && empty($referentie))) {
            unset($this->referentie);
        } else {
            $this->referentie = $referentie;
        }
        return $this;
    }
    /**
     * Get externeOpmerkingen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExterneOpmerkingen()
    {
        return isset($this->externeOpmerkingen) ? $this->externeOpmerkingen : null;
    }
    /**
     * Set externeOpmerkingen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externeOpmerkingen
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setExterneOpmerkingen($externeOpmerkingen = null)
    {
        // validation for constraint: string
        if (!is_null($externeOpmerkingen) && !is_string($externeOpmerkingen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externeOpmerkingen, true), gettype($externeOpmerkingen)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($externeOpmerkingen) && mb_strlen($externeOpmerkingen) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($externeOpmerkingen)), __LINE__);
        }
        if (is_null($externeOpmerkingen) || (is_array($externeOpmerkingen) && empty($externeOpmerkingen))) {
            unset($this->externeOpmerkingen);
        } else {
            $this->externeOpmerkingen = $externeOpmerkingen;
        }
        return $this;
    }
    /**
     * Get betaalwijzeKenmerk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBetaalwijzeKenmerk()
    {
        return isset($this->betaalwijzeKenmerk) ? $this->betaalwijzeKenmerk : null;
    }
    /**
     * Set betaalwijzeKenmerk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $betaalwijzeKenmerk
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setBetaalwijzeKenmerk($betaalwijzeKenmerk = null)
    {
        // validation for constraint: string
        if (!is_null($betaalwijzeKenmerk) && !is_string($betaalwijzeKenmerk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($betaalwijzeKenmerk, true), gettype($betaalwijzeKenmerk)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($betaalwijzeKenmerk) && mb_strlen($betaalwijzeKenmerk) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($betaalwijzeKenmerk)), __LINE__);
        }
        if (is_null($betaalwijzeKenmerk) || (is_array($betaalwijzeKenmerk) && empty($betaalwijzeKenmerk))) {
            unset($this->betaalwijzeKenmerk);
        } else {
            $this->betaalwijzeKenmerk = $betaalwijzeKenmerk;
        }
        return $this;
    }
    /**
     * Get betaalreferentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBetaalreferentie()
    {
        return isset($this->betaalreferentie) ? $this->betaalreferentie : null;
    }
    /**
     * Set betaalreferentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $betaalreferentie
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setBetaalreferentie($betaalreferentie = null)
    {
        // validation for constraint: string
        if (!is_null($betaalreferentie) && !is_string($betaalreferentie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($betaalreferentie, true), gettype($betaalreferentie)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($betaalreferentie) && mb_strlen($betaalreferentie) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($betaalreferentie)), __LINE__);
        }
        if (is_null($betaalreferentie) || (is_array($betaalreferentie) && empty($betaalreferentie))) {
            unset($this->betaalreferentie);
        } else {
            $this->betaalreferentie = $betaalreferentie;
        }
        return $this;
    }
    /**
     * Get betalingsconditie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\BetalingsconditieRecV5|null
     */
    public function getBetalingsconditie()
    {
        return isset($this->betalingsconditie) ? $this->betalingsconditie : null;
    }
    /**
     * Set betalingsconditie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\BetalingsconditieRecV5 $betalingsconditie
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setBetalingsconditie(\VoorraadApiV5\StructType\BetalingsconditieRecV5 $betalingsconditie = null)
    {
        if (is_null($betalingsconditie) || (is_array($betalingsconditie) && empty($betalingsconditie))) {
            unset($this->betalingsconditie);
        } else {
            $this->betalingsconditie = $betalingsconditie;
        }
        return $this;
    }
    /**
     * Get verzendwijze value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\VerzendwijzeRecV5|null
     */
    public function getVerzendwijze()
    {
        return isset($this->verzendwijze) ? $this->verzendwijze : null;
    }
    /**
     * Set verzendwijze value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\VerzendwijzeRecV5 $verzendwijze
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setVerzendwijze(\VoorraadApiV5\StructType\VerzendwijzeRecV5 $verzendwijze = null)
    {
        if (is_null($verzendwijze) || (is_array($verzendwijze) && empty($verzendwijze))) {
            unset($this->verzendwijze);
        } else {
            $this->verzendwijze = $verzendwijze;
        }
        return $this;
    }
    /**
     * Get leverstatusCbTekstKort value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeverstatusCbTekstKort()
    {
        return isset($this->leverstatusCbTekstKort) ? $this->leverstatusCbTekstKort : null;
    }
    /**
     * Set leverstatusCbTekstKort value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leverstatusCbTekstKort
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setLeverstatusCbTekstKort($leverstatusCbTekstKort = null)
    {
        // validation for constraint: string
        if (!is_null($leverstatusCbTekstKort) && !is_string($leverstatusCbTekstKort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leverstatusCbTekstKort, true), gettype($leverstatusCbTekstKort)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($leverstatusCbTekstKort) && mb_strlen($leverstatusCbTekstKort) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($leverstatusCbTekstKort)), __LINE__);
        }
        if (is_null($leverstatusCbTekstKort) || (is_array($leverstatusCbTekstKort) && empty($leverstatusCbTekstKort))) {
            unset($this->leverstatusCbTekstKort);
        } else {
            $this->leverstatusCbTekstKort = $leverstatusCbTekstKort;
        }
        return $this;
    }
    /**
     * Get leverstatusCbTekstLang value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeverstatusCbTekstLang()
    {
        return isset($this->leverstatusCbTekstLang) ? $this->leverstatusCbTekstLang : null;
    }
    /**
     * Set leverstatusCbTekstLang value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leverstatusCbTekstLang
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setLeverstatusCbTekstLang($leverstatusCbTekstLang = null)
    {
        // validation for constraint: string
        if (!is_null($leverstatusCbTekstLang) && !is_string($leverstatusCbTekstLang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leverstatusCbTekstLang, true), gettype($leverstatusCbTekstLang)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($leverstatusCbTekstLang) && mb_strlen($leverstatusCbTekstLang) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($leverstatusCbTekstLang)), __LINE__);
        }
        if (is_null($leverstatusCbTekstLang) || (is_array($leverstatusCbTekstLang) && empty($leverstatusCbTekstLang))) {
            unset($this->leverstatusCbTekstLang);
        } else {
            $this->leverstatusCbTekstLang = $leverstatusCbTekstLang;
        }
        return $this;
    }
    /**
     * Get vrijeVelden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\VrijeVeldenVrdRecV5|null
     */
    public function getVrijeVelden()
    {
        return isset($this->vrijeVelden) ? $this->vrijeVelden : null;
    }
    /**
     * Set vrijeVelden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\VrijeVeldenVrdRecV5 $vrijeVelden
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setVrijeVelden(\VoorraadApiV5\StructType\VrijeVeldenVrdRecV5 $vrijeVelden = null)
    {
        if (is_null($vrijeVelden) || (is_array($vrijeVelden) && empty($vrijeVelden))) {
            unset($this->vrijeVelden);
        } else {
            $this->vrijeVelden = $vrijeVelden;
        }
        return $this;
    }
    /**
     * Get regels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoTabV5|null
     */
    public function getRegels()
    {
        return isset($this->regels) ? $this->regels : null;
    }
    /**
     * Set regels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\VerkooporderregelInfoTabV5 $regels
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public function setRegels(\VoorraadApiV5\StructType\VerkooporderregelInfoTabV5 $regels = null)
    {
        if (is_null($regels) || (is_array($regels) && empty($regels))) {
            unset($this->regels);
        } else {
            $this->regels = $regels;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
