<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RechthebbendeRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Rechthebbende van een publicatie
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class RechthebbendeRecV5 extends AbstractStructBase
{
    /**
     * The relatienummer
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van de rechthebbende.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $relatienummer;
    /**
     * The volgnr
     * Meta informations extracted from the WSDL
     * - documentation: Volgnummer om de juiste volgorde van rechthebbenden te bepalen
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $volgnr;
    /**
     * The naam
     * Meta informations extracted from the WSDL
     * - documentation: Naam de rechthebbende.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $naam;
    /**
     * The vrijeVelden
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\RechthebbendeVrijeVeldenV5
     */
    public $vrijeVelden;
    /**
     * Constructor method for RechthebbendeRecV5
     * @uses RechthebbendeRecV5::setRelatienummer()
     * @uses RechthebbendeRecV5::setVolgnr()
     * @uses RechthebbendeRecV5::setNaam()
     * @uses RechthebbendeRecV5::setVrijeVelden()
     * @param float $relatienummer
     * @param float $volgnr
     * @param string $naam
     * @param \VoorraadApiV5\StructType\RechthebbendeVrijeVeldenV5 $vrijeVelden
     */
    public function __construct($relatienummer = null, $volgnr = null, $naam = null, \VoorraadApiV5\StructType\RechthebbendeVrijeVeldenV5 $vrijeVelden = null)
    {
        $this
            ->setRelatienummer($relatienummer)
            ->setVolgnr($volgnr)
            ->setNaam($naam)
            ->setVrijeVelden($vrijeVelden);
    }
    /**
     * Get relatienummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRelatienummer()
    {
        return isset($this->relatienummer) ? $this->relatienummer : null;
    }
    /**
     * Set relatienummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $relatienummer
     * @return \VoorraadApiV5\StructType\RechthebbendeRecV5
     */
    public function setRelatienummer($relatienummer = null)
    {
        // validation for constraint: float
        if (!is_null($relatienummer) && !(is_float($relatienummer) || is_numeric($relatienummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($relatienummer, true), gettype($relatienummer)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($relatienummer) && mb_strlen(preg_replace('/(\D)/', '', $relatienummer)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($relatienummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummer))), __LINE__);
        }
        if (is_null($relatienummer) || (is_array($relatienummer) && empty($relatienummer))) {
            unset($this->relatienummer);
        } else {
            $this->relatienummer = $relatienummer;
        }
        return $this;
    }
    /**
     * Get volgnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVolgnr()
    {
        return isset($this->volgnr) ? $this->volgnr : null;
    }
    /**
     * Set volgnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $volgnr
     * @return \VoorraadApiV5\StructType\RechthebbendeRecV5
     */
    public function setVolgnr($volgnr = null)
    {
        // validation for constraint: float
        if (!is_null($volgnr) && !(is_float($volgnr) || is_numeric($volgnr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volgnr, true), gettype($volgnr)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($volgnr) && mb_strlen(preg_replace('/(\D)/', '', $volgnr)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($volgnr, true), mb_strlen(preg_replace('/(\D)/', '', $volgnr))), __LINE__);
        }
        if (is_null($volgnr) || (is_array($volgnr) && empty($volgnr))) {
            unset($this->volgnr);
        } else {
            $this->volgnr = $volgnr;
        }
        return $this;
    }
    /**
     * Get naam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaam()
    {
        return isset($this->naam) ? $this->naam : null;
    }
    /**
     * Set naam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naam
     * @return \VoorraadApiV5\StructType\RechthebbendeRecV5
     */
    public function setNaam($naam = null)
    {
        // validation for constraint: string
        if (!is_null($naam) && !is_string($naam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naam, true), gettype($naam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($naam) && mb_strlen($naam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($naam)), __LINE__);
        }
        if (is_null($naam) || (is_array($naam) && empty($naam))) {
            unset($this->naam);
        } else {
            $this->naam = $naam;
        }
        return $this;
    }
    /**
     * Get vrijeVelden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\RechthebbendeVrijeVeldenV5|null
     */
    public function getVrijeVelden()
    {
        return isset($this->vrijeVelden) ? $this->vrijeVelden : null;
    }
    /**
     * Set vrijeVelden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\RechthebbendeVrijeVeldenV5 $vrijeVelden
     * @return \VoorraadApiV5\StructType\RechthebbendeRecV5
     */
    public function setVrijeVelden(\VoorraadApiV5\StructType\RechthebbendeVrijeVeldenV5 $vrijeVelden = null)
    {
        if (is_null($vrijeVelden) || (is_array($vrijeVelden) && empty($vrijeVelden))) {
            unset($this->vrijeVelden);
        } else {
            $this->vrijeVelden = $vrijeVelden;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\RechthebbendeRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
