<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LeverantieregeltableV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met leverantieregels
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class LeverantieregeltableV5 extends AbstractStructBase
{
    /**
     * The leverantieregel
     * Meta informations extracted from the WSDL
     * - documentation: LeverantieregelRec
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: false
     * @var \VoorraadApiV5\StructType\LeverantieregelRecV5[]
     */
    public $leverantieregel;
    /**
     * Constructor method for LeverantieregeltableV5
     * @uses LeverantieregeltableV5::setLeverantieregel()
     * @param \VoorraadApiV5\StructType\LeverantieregelRecV5[] $leverantieregel
     */
    public function __construct(array $leverantieregel = array())
    {
        $this
            ->setLeverantieregel($leverantieregel);
    }
    /**
     * Get leverantieregel value
     * @return \VoorraadApiV5\StructType\LeverantieregelRecV5[]
     */
    public function getLeverantieregel()
    {
        return $this->leverantieregel;
    }
    /**
     * This method is responsible for validating the values passed to the setLeverantieregel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeverantieregel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLeverantieregelForArrayConstraintsFromSetLeverantieregel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leverantieregeltableV5LeverantieregelItem) {
            // validation for constraint: itemType
            if (!$leverantieregeltableV5LeverantieregelItem instanceof \VoorraadApiV5\StructType\LeverantieregelRecV5) {
                $invalidValues[] = is_object($leverantieregeltableV5LeverantieregelItem) ? get_class($leverantieregeltableV5LeverantieregelItem) : sprintf('%s(%s)', gettype($leverantieregeltableV5LeverantieregelItem), var_export($leverantieregeltableV5LeverantieregelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The leverantieregel property can only contain items of type \VoorraadApiV5\StructType\LeverantieregelRecV5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set leverantieregel value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\LeverantieregelRecV5[] $leverantieregel
     * @return \VoorraadApiV5\StructType\LeverantieregeltableV5
     */
    public function setLeverantieregel(array $leverantieregel = array())
    {
        // validation for constraint: array
        if ('' !== ($leverantieregelArrayErrorMessage = self::validateLeverantieregelForArrayConstraintsFromSetLeverantieregel($leverantieregel))) {
            throw new \InvalidArgumentException($leverantieregelArrayErrorMessage, __LINE__);
        }
        $this->leverantieregel = $leverantieregel;
        return $this;
    }
    /**
     * Add item to leverantieregel value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\LeverantieregelRecV5 $item
     * @return \VoorraadApiV5\StructType\LeverantieregeltableV5
     */
    public function addToLeverantieregel(\VoorraadApiV5\StructType\LeverantieregelRecV5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \VoorraadApiV5\StructType\LeverantieregelRecV5) {
            throw new \InvalidArgumentException(sprintf('The leverantieregel property can only contain items of type \VoorraadApiV5\StructType\LeverantieregelRecV5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->leverantieregel[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\LeverantieregeltableV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
