<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getRelatieArtikelPrijsResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error502: De ordersoort is niet gevonden | error500: De relatie is niet gevonden
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class GetRelatieArtikelPrijsResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The prijs
     * Meta informations extracted from the WSDL
     * - documentation: De prijs (ex-btw) van het artikel * het aantal
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $prijs;
    /**
     * The prijsPerStuk
     * Meta informations extracted from the WSDL
     * - documentation: De prijs (ex-btw) van het artikel per stuk
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $prijsPerStuk;
    /**
     * The kortingBedrag
     * Meta informations extracted from the WSDL
     * - documentation: Bedrag korting ten opzichte van de standaardprijs van het artikel rekening houdend met het relatie nummer, het aantal en de datum * het aantal
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingBedrag;
    /**
     * The kortingStaffel
     * Meta informations extracted from the WSDL
     * - documentation: De van toepassing zijnde kortings staffel
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingStaffel;
    /**
     * The kortingStaffelPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Het van toepassing zijnde staffel percentage
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $kortingStaffelPercentage;
    /**
     * The kortingPrijsmatrix
     * Meta informations extracted from the WSDL
     * - documentation: Korting volgens de prijsmatrix
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingPrijsmatrix;
    /**
     * The kortingPrijsmatrixPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Kortingspercentage volgens de prijsmatrix
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $kortingPrijsmatrixPercentage;
    /**
     * The kortingPrijsmatrixOmschr
     * Meta informations extracted from the WSDL
     * - documentation: Kortingsomschrijving volgens de prijsmatrix
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kortingPrijsmatrixOmschr;
    /**
     * The kortingOrdersoort
     * Meta informations extracted from the WSDL
     * - documentation: Korting bedrag volgens de ordersoort
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingOrdersoort;
    /**
     * The kortingOrdersoortPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Kortingspercentage volgens de ordersoort
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $kortingOrdersoortPercentage;
    /**
     * The kortingOrdersoortOmschr
     * Meta informations extracted from the WSDL
     * - documentation: Kortingsomschrijving volgens de ordersoort
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kortingOrdersoortOmschr;
    /**
     * The btwPercentage
     * Meta informations extracted from the WSDL
     * - documentation: BTW percentage dat van toepassing is op het artikel voor de opgegeven relatie
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $btwPercentage;
    /**
     * The btwBedrag
     * Meta informations extracted from the WSDL
     * - documentation: BTW bedrag over de totaalprijs minus de kortingen
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $btwBedrag;
    /**
     * Constructor method for getRelatieArtikelPrijsResponse
     * @uses GetRelatieArtikelPrijsResponse::setRequestTag()
     * @uses GetRelatieArtikelPrijsResponse::setPrijs()
     * @uses GetRelatieArtikelPrijsResponse::setPrijsPerStuk()
     * @uses GetRelatieArtikelPrijsResponse::setKortingBedrag()
     * @uses GetRelatieArtikelPrijsResponse::setKortingStaffel()
     * @uses GetRelatieArtikelPrijsResponse::setKortingStaffelPercentage()
     * @uses GetRelatieArtikelPrijsResponse::setKortingPrijsmatrix()
     * @uses GetRelatieArtikelPrijsResponse::setKortingPrijsmatrixPercentage()
     * @uses GetRelatieArtikelPrijsResponse::setKortingPrijsmatrixOmschr()
     * @uses GetRelatieArtikelPrijsResponse::setKortingOrdersoort()
     * @uses GetRelatieArtikelPrijsResponse::setKortingOrdersoortPercentage()
     * @uses GetRelatieArtikelPrijsResponse::setKortingOrdersoortOmschr()
     * @uses GetRelatieArtikelPrijsResponse::setBtwPercentage()
     * @uses GetRelatieArtikelPrijsResponse::setBtwBedrag()
     * @param string $requestTag
     * @param float $prijs
     * @param float $prijsPerStuk
     * @param float $kortingBedrag
     * @param float $kortingStaffel
     * @param float $kortingStaffelPercentage
     * @param float $kortingPrijsmatrix
     * @param float $kortingPrijsmatrixPercentage
     * @param string $kortingPrijsmatrixOmschr
     * @param float $kortingOrdersoort
     * @param float $kortingOrdersoortPercentage
     * @param string $kortingOrdersoortOmschr
     * @param float $btwPercentage
     * @param float $btwBedrag
     */
    public function __construct($requestTag = null, $prijs = null, $prijsPerStuk = null, $kortingBedrag = null, $kortingStaffel = null, $kortingStaffelPercentage = null, $kortingPrijsmatrix = null, $kortingPrijsmatrixPercentage = null, $kortingPrijsmatrixOmschr = null, $kortingOrdersoort = null, $kortingOrdersoortPercentage = null, $kortingOrdersoortOmschr = null, $btwPercentage = null, $btwBedrag = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setPrijs($prijs)
            ->setPrijsPerStuk($prijsPerStuk)
            ->setKortingBedrag($kortingBedrag)
            ->setKortingStaffel($kortingStaffel)
            ->setKortingStaffelPercentage($kortingStaffelPercentage)
            ->setKortingPrijsmatrix($kortingPrijsmatrix)
            ->setKortingPrijsmatrixPercentage($kortingPrijsmatrixPercentage)
            ->setKortingPrijsmatrixOmschr($kortingPrijsmatrixOmschr)
            ->setKortingOrdersoort($kortingOrdersoort)
            ->setKortingOrdersoortPercentage($kortingOrdersoortPercentage)
            ->setKortingOrdersoortOmschr($kortingOrdersoortOmschr)
            ->setBtwPercentage($btwPercentage)
            ->setBtwBedrag($btwBedrag);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get prijs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijs()
    {
        return isset($this->prijs) ? $this->prijs : null;
    }
    /**
     * Set prijs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijs
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsResponse
     */
    public function setPrijs($prijs = null)
    {
        // validation for constraint: float
        if (!is_null($prijs) && !(is_float($prijs) || is_numeric($prijs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijs, true), gettype($prijs)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($prijs) && mb_strlen(preg_replace('/(\D)/', '', $prijs)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($prijs, true), mb_strlen(preg_replace('/(\D)/', '', $prijs))), __LINE__);
        }
        if (is_null($prijs) || (is_array($prijs) && empty($prijs))) {
            unset($this->prijs);
        } else {
            $this->prijs = $prijs;
        }
        return $this;
    }
    /**
     * Get prijsPerStuk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijsPerStuk()
    {
        return isset($this->prijsPerStuk) ? $this->prijsPerStuk : null;
    }
    /**
     * Set prijsPerStuk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijsPerStuk
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsResponse
     */
    public function setPrijsPerStuk($prijsPerStuk = null)
    {
        // validation for constraint: float
        if (!is_null($prijsPerStuk) && !(is_float($prijsPerStuk) || is_numeric($prijsPerStuk))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijsPerStuk, true), gettype($prijsPerStuk)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($prijsPerStuk) && mb_strlen(preg_replace('/(\D)/', '', $prijsPerStuk)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($prijsPerStuk, true), mb_strlen(preg_replace('/(\D)/', '', $prijsPerStuk))), __LINE__);
        }
        if (is_null($prijsPerStuk) || (is_array($prijsPerStuk) && empty($prijsPerStuk))) {
            unset($this->prijsPerStuk);
        } else {
            $this->prijsPerStuk = $prijsPerStuk;
        }
        return $this;
    }
    /**
     * Get kortingBedrag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingBedrag()
    {
        return isset($this->kortingBedrag) ? $this->kortingBedrag : null;
    }
    /**
     * Set kortingBedrag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingBedrag
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsResponse
     */
    public function setKortingBedrag($kortingBedrag = null)
    {
        // validation for constraint: float
        if (!is_null($kortingBedrag) && !(is_float($kortingBedrag) || is_numeric($kortingBedrag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingBedrag, true), gettype($kortingBedrag)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingBedrag) && mb_strlen(preg_replace('/(\D)/', '', $kortingBedrag)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingBedrag, true), mb_strlen(preg_replace('/(\D)/', '', $kortingBedrag))), __LINE__);
        }
        if (is_null($kortingBedrag) || (is_array($kortingBedrag) && empty($kortingBedrag))) {
            unset($this->kortingBedrag);
        } else {
            $this->kortingBedrag = $kortingBedrag;
        }
        return $this;
    }
    /**
     * Get kortingStaffel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingStaffel()
    {
        return isset($this->kortingStaffel) ? $this->kortingStaffel : null;
    }
    /**
     * Set kortingStaffel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingStaffel
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsResponse
     */
    public function setKortingStaffel($kortingStaffel = null)
    {
        // validation for constraint: float
        if (!is_null($kortingStaffel) && !(is_float($kortingStaffel) || is_numeric($kortingStaffel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingStaffel, true), gettype($kortingStaffel)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingStaffel) && mb_strlen(preg_replace('/(\D)/', '', $kortingStaffel)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingStaffel, true), mb_strlen(preg_replace('/(\D)/', '', $kortingStaffel))), __LINE__);
        }
        if (is_null($kortingStaffel) || (is_array($kortingStaffel) && empty($kortingStaffel))) {
            unset($this->kortingStaffel);
        } else {
            $this->kortingStaffel = $kortingStaffel;
        }
        return $this;
    }
    /**
     * Get kortingStaffelPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingStaffelPercentage()
    {
        return isset($this->kortingStaffelPercentage) ? $this->kortingStaffelPercentage : null;
    }
    /**
     * Set kortingStaffelPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingStaffelPercentage
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsResponse
     */
    public function setKortingStaffelPercentage($kortingStaffelPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($kortingStaffelPercentage) && !(is_float($kortingStaffelPercentage) || is_numeric($kortingStaffelPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingStaffelPercentage, true), gettype($kortingStaffelPercentage)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($kortingStaffelPercentage) && mb_strlen(mb_substr($kortingStaffelPercentage, mb_strpos($kortingStaffelPercentage, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($kortingStaffelPercentage, true), mb_strlen(mb_substr($kortingStaffelPercentage, mb_strpos($kortingStaffelPercentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($kortingStaffelPercentage) && mb_strlen(preg_replace('/(\D)/', '', $kortingStaffelPercentage)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($kortingStaffelPercentage, true), mb_strlen(preg_replace('/(\D)/', '', $kortingStaffelPercentage))), __LINE__);
        }
        if (is_null($kortingStaffelPercentage) || (is_array($kortingStaffelPercentage) && empty($kortingStaffelPercentage))) {
            unset($this->kortingStaffelPercentage);
        } else {
            $this->kortingStaffelPercentage = $kortingStaffelPercentage;
        }
        return $this;
    }
    /**
     * Get kortingPrijsmatrix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingPrijsmatrix()
    {
        return isset($this->kortingPrijsmatrix) ? $this->kortingPrijsmatrix : null;
    }
    /**
     * Set kortingPrijsmatrix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingPrijsmatrix
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsResponse
     */
    public function setKortingPrijsmatrix($kortingPrijsmatrix = null)
    {
        // validation for constraint: float
        if (!is_null($kortingPrijsmatrix) && !(is_float($kortingPrijsmatrix) || is_numeric($kortingPrijsmatrix))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingPrijsmatrix, true), gettype($kortingPrijsmatrix)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingPrijsmatrix) && mb_strlen(preg_replace('/(\D)/', '', $kortingPrijsmatrix)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingPrijsmatrix, true), mb_strlen(preg_replace('/(\D)/', '', $kortingPrijsmatrix))), __LINE__);
        }
        if (is_null($kortingPrijsmatrix) || (is_array($kortingPrijsmatrix) && empty($kortingPrijsmatrix))) {
            unset($this->kortingPrijsmatrix);
        } else {
            $this->kortingPrijsmatrix = $kortingPrijsmatrix;
        }
        return $this;
    }
    /**
     * Get kortingPrijsmatrixPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingPrijsmatrixPercentage()
    {
        return isset($this->kortingPrijsmatrixPercentage) ? $this->kortingPrijsmatrixPercentage : null;
    }
    /**
     * Set kortingPrijsmatrixPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingPrijsmatrixPercentage
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsResponse
     */
    public function setKortingPrijsmatrixPercentage($kortingPrijsmatrixPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($kortingPrijsmatrixPercentage) && !(is_float($kortingPrijsmatrixPercentage) || is_numeric($kortingPrijsmatrixPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingPrijsmatrixPercentage, true), gettype($kortingPrijsmatrixPercentage)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($kortingPrijsmatrixPercentage) && mb_strlen(mb_substr($kortingPrijsmatrixPercentage, mb_strpos($kortingPrijsmatrixPercentage, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($kortingPrijsmatrixPercentage, true), mb_strlen(mb_substr($kortingPrijsmatrixPercentage, mb_strpos($kortingPrijsmatrixPercentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($kortingPrijsmatrixPercentage) && mb_strlen(preg_replace('/(\D)/', '', $kortingPrijsmatrixPercentage)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($kortingPrijsmatrixPercentage, true), mb_strlen(preg_replace('/(\D)/', '', $kortingPrijsmatrixPercentage))), __LINE__);
        }
        if (is_null($kortingPrijsmatrixPercentage) || (is_array($kortingPrijsmatrixPercentage) && empty($kortingPrijsmatrixPercentage))) {
            unset($this->kortingPrijsmatrixPercentage);
        } else {
            $this->kortingPrijsmatrixPercentage = $kortingPrijsmatrixPercentage;
        }
        return $this;
    }
    /**
     * Get kortingPrijsmatrixOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKortingPrijsmatrixOmschr()
    {
        return isset($this->kortingPrijsmatrixOmschr) ? $this->kortingPrijsmatrixOmschr : null;
    }
    /**
     * Set kortingPrijsmatrixOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kortingPrijsmatrixOmschr
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsResponse
     */
    public function setKortingPrijsmatrixOmschr($kortingPrijsmatrixOmschr = null)
    {
        // validation for constraint: string
        if (!is_null($kortingPrijsmatrixOmschr) && !is_string($kortingPrijsmatrixOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kortingPrijsmatrixOmschr, true), gettype($kortingPrijsmatrixOmschr)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($kortingPrijsmatrixOmschr) && mb_strlen($kortingPrijsmatrixOmschr) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($kortingPrijsmatrixOmschr)), __LINE__);
        }
        if (is_null($kortingPrijsmatrixOmschr) || (is_array($kortingPrijsmatrixOmschr) && empty($kortingPrijsmatrixOmschr))) {
            unset($this->kortingPrijsmatrixOmschr);
        } else {
            $this->kortingPrijsmatrixOmschr = $kortingPrijsmatrixOmschr;
        }
        return $this;
    }
    /**
     * Get kortingOrdersoort value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingOrdersoort()
    {
        return isset($this->kortingOrdersoort) ? $this->kortingOrdersoort : null;
    }
    /**
     * Set kortingOrdersoort value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingOrdersoort
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsResponse
     */
    public function setKortingOrdersoort($kortingOrdersoort = null)
    {
        // validation for constraint: float
        if (!is_null($kortingOrdersoort) && !(is_float($kortingOrdersoort) || is_numeric($kortingOrdersoort))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingOrdersoort, true), gettype($kortingOrdersoort)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingOrdersoort) && mb_strlen(preg_replace('/(\D)/', '', $kortingOrdersoort)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingOrdersoort, true), mb_strlen(preg_replace('/(\D)/', '', $kortingOrdersoort))), __LINE__);
        }
        if (is_null($kortingOrdersoort) || (is_array($kortingOrdersoort) && empty($kortingOrdersoort))) {
            unset($this->kortingOrdersoort);
        } else {
            $this->kortingOrdersoort = $kortingOrdersoort;
        }
        return $this;
    }
    /**
     * Get kortingOrdersoortPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingOrdersoortPercentage()
    {
        return isset($this->kortingOrdersoortPercentage) ? $this->kortingOrdersoortPercentage : null;
    }
    /**
     * Set kortingOrdersoortPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingOrdersoortPercentage
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsResponse
     */
    public function setKortingOrdersoortPercentage($kortingOrdersoortPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($kortingOrdersoortPercentage) && !(is_float($kortingOrdersoortPercentage) || is_numeric($kortingOrdersoortPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingOrdersoortPercentage, true), gettype($kortingOrdersoortPercentage)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($kortingOrdersoortPercentage) && mb_strlen(mb_substr($kortingOrdersoortPercentage, mb_strpos($kortingOrdersoortPercentage, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($kortingOrdersoortPercentage, true), mb_strlen(mb_substr($kortingOrdersoortPercentage, mb_strpos($kortingOrdersoortPercentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($kortingOrdersoortPercentage) && mb_strlen(preg_replace('/(\D)/', '', $kortingOrdersoortPercentage)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($kortingOrdersoortPercentage, true), mb_strlen(preg_replace('/(\D)/', '', $kortingOrdersoortPercentage))), __LINE__);
        }
        if (is_null($kortingOrdersoortPercentage) || (is_array($kortingOrdersoortPercentage) && empty($kortingOrdersoortPercentage))) {
            unset($this->kortingOrdersoortPercentage);
        } else {
            $this->kortingOrdersoortPercentage = $kortingOrdersoortPercentage;
        }
        return $this;
    }
    /**
     * Get kortingOrdersoortOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKortingOrdersoortOmschr()
    {
        return isset($this->kortingOrdersoortOmschr) ? $this->kortingOrdersoortOmschr : null;
    }
    /**
     * Set kortingOrdersoortOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kortingOrdersoortOmschr
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsResponse
     */
    public function setKortingOrdersoortOmschr($kortingOrdersoortOmschr = null)
    {
        // validation for constraint: string
        if (!is_null($kortingOrdersoortOmschr) && !is_string($kortingOrdersoortOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kortingOrdersoortOmschr, true), gettype($kortingOrdersoortOmschr)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($kortingOrdersoortOmschr) && mb_strlen($kortingOrdersoortOmschr) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($kortingOrdersoortOmschr)), __LINE__);
        }
        if (is_null($kortingOrdersoortOmschr) || (is_array($kortingOrdersoortOmschr) && empty($kortingOrdersoortOmschr))) {
            unset($this->kortingOrdersoortOmschr);
        } else {
            $this->kortingOrdersoortOmschr = $kortingOrdersoortOmschr;
        }
        return $this;
    }
    /**
     * Get btwPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBtwPercentage()
    {
        return isset($this->btwPercentage) ? $this->btwPercentage : null;
    }
    /**
     * Set btwPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $btwPercentage
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsResponse
     */
    public function setBtwPercentage($btwPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($btwPercentage) && !(is_float($btwPercentage) || is_numeric($btwPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($btwPercentage, true), gettype($btwPercentage)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($btwPercentage) && mb_strlen(preg_replace('/(\D)/', '', $btwPercentage)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($btwPercentage, true), mb_strlen(preg_replace('/(\D)/', '', $btwPercentage))), __LINE__);
        }
        if (is_null($btwPercentage) || (is_array($btwPercentage) && empty($btwPercentage))) {
            unset($this->btwPercentage);
        } else {
            $this->btwPercentage = $btwPercentage;
        }
        return $this;
    }
    /**
     * Get btwBedrag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBtwBedrag()
    {
        return isset($this->btwBedrag) ? $this->btwBedrag : null;
    }
    /**
     * Set btwBedrag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $btwBedrag
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsResponse
     */
    public function setBtwBedrag($btwBedrag = null)
    {
        // validation for constraint: float
        if (!is_null($btwBedrag) && !(is_float($btwBedrag) || is_numeric($btwBedrag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($btwBedrag, true), gettype($btwBedrag)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($btwBedrag) && mb_strlen(preg_replace('/(\D)/', '', $btwBedrag)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($btwBedrag, true), mb_strlen(preg_replace('/(\D)/', '', $btwBedrag))), __LINE__);
        }
        if (is_null($btwBedrag) || (is_array($btwBedrag) && empty($btwBedrag))) {
            unset($this->btwBedrag);
        } else {
            $this->btwBedrag = $btwBedrag;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
