<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FondsGroepTableV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met beschikbare fonds groepen.
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class FondsGroepTableV5 extends AbstractStructBase
{
    /**
     * The fondsGroep
     * Meta informations extracted from the WSDL
     * - documentation: Fondsgroep
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \VoorraadApiV5\StructType\FondsGroepRecV5[]
     */
    public $fondsGroep;
    /**
     * Constructor method for FondsGroepTableV5
     * @uses FondsGroepTableV5::setFondsGroep()
     * @param \VoorraadApiV5\StructType\FondsGroepRecV5[] $fondsGroep
     */
    public function __construct(array $fondsGroep = array())
    {
        $this
            ->setFondsGroep($fondsGroep);
    }
    /**
     * Get fondsGroep value
     * @return \VoorraadApiV5\StructType\FondsGroepRecV5[]|null
     */
    public function getFondsGroep()
    {
        return $this->fondsGroep;
    }
    /**
     * This method is responsible for validating the values passed to the setFondsGroep method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFondsGroep method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFondsGroepForArrayConstraintsFromSetFondsGroep(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fondsGroepTableV5FondsGroepItem) {
            // validation for constraint: itemType
            if (!$fondsGroepTableV5FondsGroepItem instanceof \VoorraadApiV5\StructType\FondsGroepRecV5) {
                $invalidValues[] = is_object($fondsGroepTableV5FondsGroepItem) ? get_class($fondsGroepTableV5FondsGroepItem) : sprintf('%s(%s)', gettype($fondsGroepTableV5FondsGroepItem), var_export($fondsGroepTableV5FondsGroepItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The fondsGroep property can only contain items of type \VoorraadApiV5\StructType\FondsGroepRecV5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set fondsGroep value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\FondsGroepRecV5[] $fondsGroep
     * @return \VoorraadApiV5\StructType\FondsGroepTableV5
     */
    public function setFondsGroep(array $fondsGroep = array())
    {
        // validation for constraint: array
        if ('' !== ($fondsGroepArrayErrorMessage = self::validateFondsGroepForArrayConstraintsFromSetFondsGroep($fondsGroep))) {
            throw new \InvalidArgumentException($fondsGroepArrayErrorMessage, __LINE__);
        }
        $this->fondsGroep = $fondsGroep;
        return $this;
    }
    /**
     * Add item to fondsGroep value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\FondsGroepRecV5 $item
     * @return \VoorraadApiV5\StructType\FondsGroepTableV5
     */
    public function addToFondsGroep(\VoorraadApiV5\StructType\FondsGroepRecV5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \VoorraadApiV5\StructType\FondsGroepRecV5) {
            throw new \InvalidArgumentException(sprintf('The fondsGroep property can only contain items of type \VoorraadApiV5\StructType\FondsGroepRecV5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->fondsGroep[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\FondsGroepTableV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
