<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createVerkoopOrderRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Aanmaken van een verkooporder. Afleveradres is standaard het bezoekadres (indien afleverenOpPrive en afleverenOpCorrespondentie beide waarde 0 hebben). Factuuradres is standaard het correspondentieadres (indien factuurOpPrive en
 * factuurOpBezoek beide waarde 0 hebben).
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class CreateVerkoopOrderRequest extends AbstractStructBase
{
    /**
     * The relatienummerBesteller
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van de relatie die de order bestelt
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerBesteller;
    /**
     * The relatienummerDebiteur
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van de debiteur van de order
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerDebiteur;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The ordersoortCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van de te gebruiken ordersoort. Indien niet meegegeven, wordt de standaard 'internet' ordersoort gebruikt.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ordersoortCode;
    /**
     * The orderDatum
     * Meta informations extracted from the WSDL
     * - documentation: De gewenste orderdatum (default de huidige datum)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $orderDatum;
    /**
     * The betaal
     * Meta informations extracted from the WSDL
     * - documentation: Betaalgegevens
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\BetaalRecV5
     */
    public $betaal;
    /**
     * The betaalreferentie
     * Meta informations extracted from the WSDL
     * - documentation: De betaalrefentie. In geval van betaling met iDeal het iDeal kenmerk
     * - base: xsd:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $betaalreferentie;
    /**
     * The referentie
     * Meta informations extracted from the WSDL
     * - documentation: Referentie waaraan de order herkend kan worden
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $referentie;
    /**
     * The verzendwijzeCode
     * Meta informations extracted from the WSDL
     * - documentation: Code voor de verzendwijze
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $verzendwijzeCode;
    /**
     * The betalingsconditieCode
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $betalingsconditieCode;
    /**
     * The afleverenOpPrive
     * Meta informations extracted from the WSDL
     * - documentation: 0(Default)= Niet afleveren op prive adres, 1= Afleveren op privéadres
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 3
     * @var int
     */
    public $afleverenOpPrive;
    /**
     * The factuurOpPrive
     * Meta informations extracted from the WSDL
     * - documentation: 0(Default)= Factuur niet verzenden naar prive adres, 1= Factuur verzenden naar privéadres
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 3
     * @var int
     */
    public $factuurOpPrive;
    /**
     * The valutaCode
     * Meta informations extracted from the WSDL
     * - documentation: Valutacode, indien de order in vreemde valuta is.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $valutaCode;
    /**
     * The adresAflever
     * Meta informations extracted from the WSDL
     * - documentation: Vrij in te voeren aflevergegevens (adres + gegevens ontvanger)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\OrderAfleverRecV5
     */
    public $adresAflever;
    /**
     * The orderregels
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met op de order op te nemen orderregels
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\OrderregeltableV5
     */
    public $orderregels;
    /**
     * The afleverenOpCorrespondentie
     * Meta informations extracted from the WSDL
     * - documentation: 0(Default)= Niet afleveren op correspondentieadres, 1= Afleveren op correspondentieadres
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 3
     * @var int
     */
    public $afleverenOpCorrespondentie;
    /**
     * The factuurOpBezoek
     * Meta informations extracted from the WSDL
     * - documentation: 0(Default)= Factuur niet verzenden naar bezoekadres, 1= Factuur verzenden naar bezoekadres
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 3
     * @var int
     */
    public $factuurOpBezoek;
    /**
     * The vrijeVelden
     * Meta informations extracted from the WSDL
     * - documentation: Vrije velden van de order.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\VrijeVeldenVrdRecV5
     */
    public $vrijeVelden;
    /**
     * Constructor method for createVerkoopOrderRequest
     * @uses CreateVerkoopOrderRequest::setRelatienummerBesteller()
     * @uses CreateVerkoopOrderRequest::setRelatienummerDebiteur()
     * @uses CreateVerkoopOrderRequest::setRequestTag()
     * @uses CreateVerkoopOrderRequest::setOrdersoortCode()
     * @uses CreateVerkoopOrderRequest::setOrderDatum()
     * @uses CreateVerkoopOrderRequest::setBetaal()
     * @uses CreateVerkoopOrderRequest::setBetaalreferentie()
     * @uses CreateVerkoopOrderRequest::setReferentie()
     * @uses CreateVerkoopOrderRequest::setVerzendwijzeCode()
     * @uses CreateVerkoopOrderRequest::setBetalingsconditieCode()
     * @uses CreateVerkoopOrderRequest::setAfleverenOpPrive()
     * @uses CreateVerkoopOrderRequest::setFactuurOpPrive()
     * @uses CreateVerkoopOrderRequest::setValutaCode()
     * @uses CreateVerkoopOrderRequest::setAdresAflever()
     * @uses CreateVerkoopOrderRequest::setOrderregels()
     * @uses CreateVerkoopOrderRequest::setAfleverenOpCorrespondentie()
     * @uses CreateVerkoopOrderRequest::setFactuurOpBezoek()
     * @uses CreateVerkoopOrderRequest::setVrijeVelden()
     * @param int $relatienummerBesteller
     * @param int $relatienummerDebiteur
     * @param string $requestTag
     * @param string $ordersoortCode
     * @param string $orderDatum
     * @param \VoorraadApiV5\StructType\BetaalRecV5 $betaal
     * @param string $betaalreferentie
     * @param string $referentie
     * @param string $verzendwijzeCode
     * @param string $betalingsconditieCode
     * @param int $afleverenOpPrive
     * @param int $factuurOpPrive
     * @param string $valutaCode
     * @param \VoorraadApiV5\StructType\OrderAfleverRecV5 $adresAflever
     * @param \VoorraadApiV5\StructType\OrderregeltableV5 $orderregels
     * @param int $afleverenOpCorrespondentie
     * @param int $factuurOpBezoek
     * @param \VoorraadApiV5\StructType\VrijeVeldenVrdRecV5 $vrijeVelden
     */
    public function __construct($relatienummerBesteller = null, $relatienummerDebiteur = null, $requestTag = null, $ordersoortCode = null, $orderDatum = null, \VoorraadApiV5\StructType\BetaalRecV5 $betaal = null, $betaalreferentie = null, $referentie = null, $verzendwijzeCode = null, $betalingsconditieCode = null, $afleverenOpPrive = null, $factuurOpPrive = null, $valutaCode = null, \VoorraadApiV5\StructType\OrderAfleverRecV5 $adresAflever = null, \VoorraadApiV5\StructType\OrderregeltableV5 $orderregels = null, $afleverenOpCorrespondentie = null, $factuurOpBezoek = null, \VoorraadApiV5\StructType\VrijeVeldenVrdRecV5 $vrijeVelden = null)
    {
        $this
            ->setRelatienummerBesteller($relatienummerBesteller)
            ->setRelatienummerDebiteur($relatienummerDebiteur)
            ->setRequestTag($requestTag)
            ->setOrdersoortCode($ordersoortCode)
            ->setOrderDatum($orderDatum)
            ->setBetaal($betaal)
            ->setBetaalreferentie($betaalreferentie)
            ->setReferentie($referentie)
            ->setVerzendwijzeCode($verzendwijzeCode)
            ->setBetalingsconditieCode($betalingsconditieCode)
            ->setAfleverenOpPrive($afleverenOpPrive)
            ->setFactuurOpPrive($factuurOpPrive)
            ->setValutaCode($valutaCode)
            ->setAdresAflever($adresAflever)
            ->setOrderregels($orderregels)
            ->setAfleverenOpCorrespondentie($afleverenOpCorrespondentie)
            ->setFactuurOpBezoek($factuurOpBezoek)
            ->setVrijeVelden($vrijeVelden);
    }
    /**
     * Get relatienummerBesteller value
     * @return int
     */
    public function getRelatienummerBesteller()
    {
        return $this->relatienummerBesteller;
    }
    /**
     * Set relatienummerBesteller value
     * @param int $relatienummerBesteller
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public function setRelatienummerBesteller($relatienummerBesteller = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummerBesteller) && !(is_int($relatienummerBesteller) || ctype_digit($relatienummerBesteller))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummerBesteller, true), gettype($relatienummerBesteller)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummerBesteller) && mb_strlen(preg_replace('/(\D)/', '', $relatienummerBesteller)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummerBesteller, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummerBesteller))), __LINE__);
        }
        $this->relatienummerBesteller = $relatienummerBesteller;
        return $this;
    }
    /**
     * Get relatienummerDebiteur value
     * @return int
     */
    public function getRelatienummerDebiteur()
    {
        return $this->relatienummerDebiteur;
    }
    /**
     * Set relatienummerDebiteur value
     * @param int $relatienummerDebiteur
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public function setRelatienummerDebiteur($relatienummerDebiteur = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummerDebiteur) && !(is_int($relatienummerDebiteur) || ctype_digit($relatienummerDebiteur))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummerDebiteur, true), gettype($relatienummerDebiteur)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummerDebiteur) && mb_strlen(preg_replace('/(\D)/', '', $relatienummerDebiteur)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummerDebiteur, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummerDebiteur))), __LINE__);
        }
        $this->relatienummerDebiteur = $relatienummerDebiteur;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get ordersoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrdersoortCode()
    {
        return isset($this->ordersoortCode) ? $this->ordersoortCode : null;
    }
    /**
     * Set ordersoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ordersoortCode
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public function setOrdersoortCode($ordersoortCode = null)
    {
        // validation for constraint: string
        if (!is_null($ordersoortCode) && !is_string($ordersoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ordersoortCode, true), gettype($ordersoortCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ordersoortCode) && mb_strlen($ordersoortCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($ordersoortCode)), __LINE__);
        }
        if (is_null($ordersoortCode) || (is_array($ordersoortCode) && empty($ordersoortCode))) {
            unset($this->ordersoortCode);
        } else {
            $this->ordersoortCode = $ordersoortCode;
        }
        return $this;
    }
    /**
     * Get orderDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderDatum()
    {
        return isset($this->orderDatum) ? $this->orderDatum : null;
    }
    /**
     * Set orderDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderDatum
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public function setOrderDatum($orderDatum = null)
    {
        // validation for constraint: string
        if (!is_null($orderDatum) && !is_string($orderDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderDatum, true), gettype($orderDatum)), __LINE__);
        }
        if (is_null($orderDatum) || (is_array($orderDatum) && empty($orderDatum))) {
            unset($this->orderDatum);
        } else {
            $this->orderDatum = $orderDatum;
        }
        return $this;
    }
    /**
     * Get betaal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\BetaalRecV5|null
     */
    public function getBetaal()
    {
        return isset($this->betaal) ? $this->betaal : null;
    }
    /**
     * Set betaal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\BetaalRecV5 $betaal
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public function setBetaal(\VoorraadApiV5\StructType\BetaalRecV5 $betaal = null)
    {
        if (is_null($betaal) || (is_array($betaal) && empty($betaal))) {
            unset($this->betaal);
        } else {
            $this->betaal = $betaal;
        }
        return $this;
    }
    /**
     * Get betaalreferentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBetaalreferentie()
    {
        return isset($this->betaalreferentie) ? $this->betaalreferentie : null;
    }
    /**
     * Set betaalreferentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $betaalreferentie
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public function setBetaalreferentie($betaalreferentie = null)
    {
        // validation for constraint: string
        if (!is_null($betaalreferentie) && !is_string($betaalreferentie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($betaalreferentie, true), gettype($betaalreferentie)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($betaalreferentie) && mb_strlen($betaalreferentie) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($betaalreferentie)), __LINE__);
        }
        if (is_null($betaalreferentie) || (is_array($betaalreferentie) && empty($betaalreferentie))) {
            unset($this->betaalreferentie);
        } else {
            $this->betaalreferentie = $betaalreferentie;
        }
        return $this;
    }
    /**
     * Get referentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferentie()
    {
        return isset($this->referentie) ? $this->referentie : null;
    }
    /**
     * Set referentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referentie
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public function setReferentie($referentie = null)
    {
        // validation for constraint: string
        if (!is_null($referentie) && !is_string($referentie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referentie, true), gettype($referentie)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($referentie) && mb_strlen($referentie) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($referentie)), __LINE__);
        }
        if (is_null($referentie) || (is_array($referentie) && empty($referentie))) {
            unset($this->referentie);
        } else {
            $this->referentie = $referentie;
        }
        return $this;
    }
    /**
     * Get verzendwijzeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVerzendwijzeCode()
    {
        return isset($this->verzendwijzeCode) ? $this->verzendwijzeCode : null;
    }
    /**
     * Set verzendwijzeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $verzendwijzeCode
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public function setVerzendwijzeCode($verzendwijzeCode = null)
    {
        // validation for constraint: string
        if (!is_null($verzendwijzeCode) && !is_string($verzendwijzeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verzendwijzeCode, true), gettype($verzendwijzeCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($verzendwijzeCode) && mb_strlen($verzendwijzeCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($verzendwijzeCode)), __LINE__);
        }
        if (is_null($verzendwijzeCode) || (is_array($verzendwijzeCode) && empty($verzendwijzeCode))) {
            unset($this->verzendwijzeCode);
        } else {
            $this->verzendwijzeCode = $verzendwijzeCode;
        }
        return $this;
    }
    /**
     * Get betalingsconditieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBetalingsconditieCode()
    {
        return isset($this->betalingsconditieCode) ? $this->betalingsconditieCode : null;
    }
    /**
     * Set betalingsconditieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $betalingsconditieCode
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public function setBetalingsconditieCode($betalingsconditieCode = null)
    {
        // validation for constraint: string
        if (!is_null($betalingsconditieCode) && !is_string($betalingsconditieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($betalingsconditieCode, true), gettype($betalingsconditieCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($betalingsconditieCode) && mb_strlen($betalingsconditieCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($betalingsconditieCode)), __LINE__);
        }
        if (is_null($betalingsconditieCode) || (is_array($betalingsconditieCode) && empty($betalingsconditieCode))) {
            unset($this->betalingsconditieCode);
        } else {
            $this->betalingsconditieCode = $betalingsconditieCode;
        }
        return $this;
    }
    /**
     * Get afleverenOpPrive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAfleverenOpPrive()
    {
        return isset($this->afleverenOpPrive) ? $this->afleverenOpPrive : null;
    }
    /**
     * Set afleverenOpPrive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $afleverenOpPrive
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public function setAfleverenOpPrive($afleverenOpPrive = null)
    {
        // validation for constraint: int
        if (!is_null($afleverenOpPrive) && !(is_int($afleverenOpPrive) || ctype_digit($afleverenOpPrive))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($afleverenOpPrive, true), gettype($afleverenOpPrive)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($afleverenOpPrive) && mb_strlen(preg_replace('/(\D)/', '', $afleverenOpPrive)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($afleverenOpPrive, true), mb_strlen(preg_replace('/(\D)/', '', $afleverenOpPrive))), __LINE__);
        }
        if (is_null($afleverenOpPrive) || (is_array($afleverenOpPrive) && empty($afleverenOpPrive))) {
            unset($this->afleverenOpPrive);
        } else {
            $this->afleverenOpPrive = $afleverenOpPrive;
        }
        return $this;
    }
    /**
     * Get factuurOpPrive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFactuurOpPrive()
    {
        return isset($this->factuurOpPrive) ? $this->factuurOpPrive : null;
    }
    /**
     * Set factuurOpPrive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $factuurOpPrive
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public function setFactuurOpPrive($factuurOpPrive = null)
    {
        // validation for constraint: int
        if (!is_null($factuurOpPrive) && !(is_int($factuurOpPrive) || ctype_digit($factuurOpPrive))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($factuurOpPrive, true), gettype($factuurOpPrive)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($factuurOpPrive) && mb_strlen(preg_replace('/(\D)/', '', $factuurOpPrive)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($factuurOpPrive, true), mb_strlen(preg_replace('/(\D)/', '', $factuurOpPrive))), __LINE__);
        }
        if (is_null($factuurOpPrive) || (is_array($factuurOpPrive) && empty($factuurOpPrive))) {
            unset($this->factuurOpPrive);
        } else {
            $this->factuurOpPrive = $factuurOpPrive;
        }
        return $this;
    }
    /**
     * Get valutaCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValutaCode()
    {
        return isset($this->valutaCode) ? $this->valutaCode : null;
    }
    /**
     * Set valutaCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valutaCode
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public function setValutaCode($valutaCode = null)
    {
        // validation for constraint: string
        if (!is_null($valutaCode) && !is_string($valutaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valutaCode, true), gettype($valutaCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($valutaCode) && mb_strlen($valutaCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($valutaCode)), __LINE__);
        }
        if (is_null($valutaCode) || (is_array($valutaCode) && empty($valutaCode))) {
            unset($this->valutaCode);
        } else {
            $this->valutaCode = $valutaCode;
        }
        return $this;
    }
    /**
     * Get adresAflever value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\OrderAfleverRecV5|null
     */
    public function getAdresAflever()
    {
        return isset($this->adresAflever) ? $this->adresAflever : null;
    }
    /**
     * Set adresAflever value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\OrderAfleverRecV5 $adresAflever
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public function setAdresAflever(\VoorraadApiV5\StructType\OrderAfleverRecV5 $adresAflever = null)
    {
        if (is_null($adresAflever) || (is_array($adresAflever) && empty($adresAflever))) {
            unset($this->adresAflever);
        } else {
            $this->adresAflever = $adresAflever;
        }
        return $this;
    }
    /**
     * Get orderregels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\OrderregeltableV5|null
     */
    public function getOrderregels()
    {
        return isset($this->orderregels) ? $this->orderregels : null;
    }
    /**
     * Set orderregels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\OrderregeltableV5 $orderregels
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public function setOrderregels(\VoorraadApiV5\StructType\OrderregeltableV5 $orderregels = null)
    {
        if (is_null($orderregels) || (is_array($orderregels) && empty($orderregels))) {
            unset($this->orderregels);
        } else {
            $this->orderregels = $orderregels;
        }
        return $this;
    }
    /**
     * Get afleverenOpCorrespondentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAfleverenOpCorrespondentie()
    {
        return isset($this->afleverenOpCorrespondentie) ? $this->afleverenOpCorrespondentie : null;
    }
    /**
     * Set afleverenOpCorrespondentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $afleverenOpCorrespondentie
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public function setAfleverenOpCorrespondentie($afleverenOpCorrespondentie = null)
    {
        // validation for constraint: int
        if (!is_null($afleverenOpCorrespondentie) && !(is_int($afleverenOpCorrespondentie) || ctype_digit($afleverenOpCorrespondentie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($afleverenOpCorrespondentie, true), gettype($afleverenOpCorrespondentie)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($afleverenOpCorrespondentie) && mb_strlen(preg_replace('/(\D)/', '', $afleverenOpCorrespondentie)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($afleverenOpCorrespondentie, true), mb_strlen(preg_replace('/(\D)/', '', $afleverenOpCorrespondentie))), __LINE__);
        }
        if (is_null($afleverenOpCorrespondentie) || (is_array($afleverenOpCorrespondentie) && empty($afleverenOpCorrespondentie))) {
            unset($this->afleverenOpCorrespondentie);
        } else {
            $this->afleverenOpCorrespondentie = $afleverenOpCorrespondentie;
        }
        return $this;
    }
    /**
     * Get factuurOpBezoek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFactuurOpBezoek()
    {
        return isset($this->factuurOpBezoek) ? $this->factuurOpBezoek : null;
    }
    /**
     * Set factuurOpBezoek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $factuurOpBezoek
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public function setFactuurOpBezoek($factuurOpBezoek = null)
    {
        // validation for constraint: int
        if (!is_null($factuurOpBezoek) && !(is_int($factuurOpBezoek) || ctype_digit($factuurOpBezoek))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($factuurOpBezoek, true), gettype($factuurOpBezoek)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($factuurOpBezoek) && mb_strlen(preg_replace('/(\D)/', '', $factuurOpBezoek)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($factuurOpBezoek, true), mb_strlen(preg_replace('/(\D)/', '', $factuurOpBezoek))), __LINE__);
        }
        if (is_null($factuurOpBezoek) || (is_array($factuurOpBezoek) && empty($factuurOpBezoek))) {
            unset($this->factuurOpBezoek);
        } else {
            $this->factuurOpBezoek = $factuurOpBezoek;
        }
        return $this;
    }
    /**
     * Get vrijeVelden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\VrijeVeldenVrdRecV5|null
     */
    public function getVrijeVelden()
    {
        return isset($this->vrijeVelden) ? $this->vrijeVelden : null;
    }
    /**
     * Set vrijeVelden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\VrijeVeldenVrdRecV5 $vrijeVelden
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public function setVrijeVelden(\VoorraadApiV5\StructType\VrijeVeldenVrdRecV5 $vrijeVelden = null)
    {
        if (is_null($vrijeVelden) || (is_array($vrijeVelden) && empty($vrijeVelden))) {
            unset($this->vrijeVelden);
        } else {
            $this->vrijeVelden = $vrijeVelden;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
