<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArtikelPrijzenTableV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: lijst met artikelprijzen
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class ArtikelPrijzenTableV5 extends AbstractStructBase
{
    /**
     * The prijzen
     * Meta informations extracted from the WSDL
     * - documentation: Prijsinformatie
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \VoorraadApiV5\StructType\ArtikelPrijzenRecV5[]
     */
    public $prijzen;
    /**
     * Constructor method for ArtikelPrijzenTableV5
     * @uses ArtikelPrijzenTableV5::setPrijzen()
     * @param \VoorraadApiV5\StructType\ArtikelPrijzenRecV5[] $prijzen
     */
    public function __construct(array $prijzen = array())
    {
        $this
            ->setPrijzen($prijzen);
    }
    /**
     * Get prijzen value
     * @return \VoorraadApiV5\StructType\ArtikelPrijzenRecV5[]|null
     */
    public function getPrijzen()
    {
        return $this->prijzen;
    }
    /**
     * This method is responsible for validating the values passed to the setPrijzen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrijzen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrijzenForArrayConstraintsFromSetPrijzen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $artikelPrijzenTableV5PrijzenItem) {
            // validation for constraint: itemType
            if (!$artikelPrijzenTableV5PrijzenItem instanceof \VoorraadApiV5\StructType\ArtikelPrijzenRecV5) {
                $invalidValues[] = is_object($artikelPrijzenTableV5PrijzenItem) ? get_class($artikelPrijzenTableV5PrijzenItem) : sprintf('%s(%s)', gettype($artikelPrijzenTableV5PrijzenItem), var_export($artikelPrijzenTableV5PrijzenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The prijzen property can only contain items of type \VoorraadApiV5\StructType\ArtikelPrijzenRecV5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set prijzen value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\ArtikelPrijzenRecV5[] $prijzen
     * @return \VoorraadApiV5\StructType\ArtikelPrijzenTableV5
     */
    public function setPrijzen(array $prijzen = array())
    {
        // validation for constraint: array
        if ('' !== ($prijzenArrayErrorMessage = self::validatePrijzenForArrayConstraintsFromSetPrijzen($prijzen))) {
            throw new \InvalidArgumentException($prijzenArrayErrorMessage, __LINE__);
        }
        $this->prijzen = $prijzen;
        return $this;
    }
    /**
     * Add item to prijzen value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\ArtikelPrijzenRecV5 $item
     * @return \VoorraadApiV5\StructType\ArtikelPrijzenTableV5
     */
    public function addToPrijzen(\VoorraadApiV5\StructType\ArtikelPrijzenRecV5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \VoorraadApiV5\StructType\ArtikelPrijzenRecV5) {
            throw new \InvalidArgumentException(sprintf('The prijzen property can only contain items of type \VoorraadApiV5\StructType\ArtikelPrijzenRecV5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->prijzen[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\ArtikelPrijzenTableV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
