<?php

namespace VoorraadApiV5\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 * @date 20190723
 * @package VoorraadApiV5
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \VoorraadApiV5\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\VoorraadApiV5\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named updateArtikel
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \VoorraadApiV5\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Bijwerken van de prijs van een artikel <br/><u>Let op:</u> bij wijzigingen van een bestaand artikel dienen alle elementen opnieuw te worden meegegeven. Lege elementen of niet meegegeven (groepen) elementen worden leeg gemaakt door de
     * update.error519: Op basis van de opgegeven code is geen artikel gevondenerror520: Op basis van de opgegeven code zijn meerdere artikelen gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \VoorraadApiV5\StructType\UpdateArtikelRequest $request_parameters
     * @return \VoorraadApiV5\StructType\UpdateArtikelResponse|bool
     */
    public function updateArtikel(\VoorraadApiV5\StructType\UpdateArtikelRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->updateArtikel($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \VoorraadApiV5\StructType\UpdateArtikelResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
