<?php

namespace VoorraadApiV5\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Order ServiceType
 * @subpackage Services
 * @date 20190723
 * @package VoorraadApiV5
 */
class Order extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \VoorraadApiV5\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\VoorraadApiV5\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named orderEBooks
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \VoorraadApiV5\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Bestellen van eBooks bij CB (eboekhuis), voor een met incasso of iDeal betaalde verkoop order. Eerst dient de boekbestelling met de gebruikelijke operatie createVerkoopOrder met succes te worden aangemaakt in Zeno. Deze bestelling
     * dient daarna te worden aangeroepen met het ordernummer, zoals geretourneerd door createverkoopOrder. Mocht er een fout optreden bij het aanroepen van de eboekhuis webservice t.b.v. het plaatsen van de bestelling, dan wordt dat ook teruggegeven in de
     * lijst met download links per artikel nummer. In dat geval kan deze functie nogmaals worden aanroepen. Boeken die de eerste keer zijn besteld, waarvan de download link ook in Zeno is vastgelegd, wordt niet nogmaals besteld. Boeken die nog moeten
     * worden besteld, of waar dat eerder fout ging worden wel besteld. De lijst met download links is altijd de volledige lijst o.b.v. alle ebooks bij een order.error530: De order is niet gevonden.error531: Nader gespecificeerde fout: ...
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \VoorraadApiV5\StructType\OrderEBooksRequest $request_parameters
     * @return \VoorraadApiV5\StructType\OrderEBooksResponse|bool
     */
    public function orderEBooks(\VoorraadApiV5\StructType\OrderEBooksRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->orderEBooks($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \VoorraadApiV5\StructType\OrderEBooksResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
