<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoorraadInfoRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Artikel vooraad informatie
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class VoorraadInfoRecV5 extends AbstractStructBase
{
    /**
     * The artikelNummer
     * Meta informations extracted from the WSDL
     * - documentation: Het artikelnummer waarvan de voorraadinformatie is opgevraagd.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $artikelNummer;
    /**
     * The voorraadEconomisch
     * Meta informations extracted from the WSDL
     * - documentation: Economische voorraad
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $voorraadEconomisch;
    /**
     * The voorraadControle
     * Meta informations extracted from the WSDL
     * - documentation: Als voorraad controle op 'Huidige voorraad' of 'Voorraad ? verkoop' staat wordt 1 gegeven, anders bij 'Geen voorraadcontrole' een 0.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $voorraadControle;
    /**
     * The magazijnen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\VoorraadInfoMagazijnTabV5
     */
    public $magazijnen;
    /**
     * Constructor method for VoorraadInfoRecV5
     * @uses VoorraadInfoRecV5::setArtikelNummer()
     * @uses VoorraadInfoRecV5::setVoorraadEconomisch()
     * @uses VoorraadInfoRecV5::setVoorraadControle()
     * @uses VoorraadInfoRecV5::setMagazijnen()
     * @param float $artikelNummer
     * @param float $voorraadEconomisch
     * @param float $voorraadControle
     * @param \VoorraadApiV5\StructType\VoorraadInfoMagazijnTabV5 $magazijnen
     */
    public function __construct($artikelNummer = null, $voorraadEconomisch = null, $voorraadControle = null, \VoorraadApiV5\StructType\VoorraadInfoMagazijnTabV5 $magazijnen = null)
    {
        $this
            ->setArtikelNummer($artikelNummer)
            ->setVoorraadEconomisch($voorraadEconomisch)
            ->setVoorraadControle($voorraadControle)
            ->setMagazijnen($magazijnen);
    }
    /**
     * Get artikelNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getArtikelNummer()
    {
        return isset($this->artikelNummer) ? $this->artikelNummer : null;
    }
    /**
     * Set artikelNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $artikelNummer
     * @return \VoorraadApiV5\StructType\VoorraadInfoRecV5
     */
    public function setArtikelNummer($artikelNummer = null)
    {
        // validation for constraint: float
        if (!is_null($artikelNummer) && !(is_float($artikelNummer) || is_numeric($artikelNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($artikelNummer, true), gettype($artikelNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($artikelNummer) && mb_strlen(preg_replace('/(\D)/', '', $artikelNummer)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($artikelNummer, true), mb_strlen(preg_replace('/(\D)/', '', $artikelNummer))), __LINE__);
        }
        if (is_null($artikelNummer) || (is_array($artikelNummer) && empty($artikelNummer))) {
            unset($this->artikelNummer);
        } else {
            $this->artikelNummer = $artikelNummer;
        }
        return $this;
    }
    /**
     * Get voorraadEconomisch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVoorraadEconomisch()
    {
        return isset($this->voorraadEconomisch) ? $this->voorraadEconomisch : null;
    }
    /**
     * Set voorraadEconomisch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $voorraadEconomisch
     * @return \VoorraadApiV5\StructType\VoorraadInfoRecV5
     */
    public function setVoorraadEconomisch($voorraadEconomisch = null)
    {
        // validation for constraint: float
        if (!is_null($voorraadEconomisch) && !(is_float($voorraadEconomisch) || is_numeric($voorraadEconomisch))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($voorraadEconomisch, true), gettype($voorraadEconomisch)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($voorraadEconomisch) && mb_strlen(preg_replace('/(\D)/', '', $voorraadEconomisch)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($voorraadEconomisch, true), mb_strlen(preg_replace('/(\D)/', '', $voorraadEconomisch))), __LINE__);
        }
        if (is_null($voorraadEconomisch) || (is_array($voorraadEconomisch) && empty($voorraadEconomisch))) {
            unset($this->voorraadEconomisch);
        } else {
            $this->voorraadEconomisch = $voorraadEconomisch;
        }
        return $this;
    }
    /**
     * Get voorraadControle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVoorraadControle()
    {
        return isset($this->voorraadControle) ? $this->voorraadControle : null;
    }
    /**
     * Set voorraadControle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $voorraadControle
     * @return \VoorraadApiV5\StructType\VoorraadInfoRecV5
     */
    public function setVoorraadControle($voorraadControle = null)
    {
        // validation for constraint: float
        if (!is_null($voorraadControle) && !(is_float($voorraadControle) || is_numeric($voorraadControle))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($voorraadControle, true), gettype($voorraadControle)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($voorraadControle) && mb_strlen(preg_replace('/(\D)/', '', $voorraadControle)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($voorraadControle, true), mb_strlen(preg_replace('/(\D)/', '', $voorraadControle))), __LINE__);
        }
        if (is_null($voorraadControle) || (is_array($voorraadControle) && empty($voorraadControle))) {
            unset($this->voorraadControle);
        } else {
            $this->voorraadControle = $voorraadControle;
        }
        return $this;
    }
    /**
     * Get magazijnen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\VoorraadInfoMagazijnTabV5|null
     */
    public function getMagazijnen()
    {
        return isset($this->magazijnen) ? $this->magazijnen : null;
    }
    /**
     * Set magazijnen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\VoorraadInfoMagazijnTabV5 $magazijnen
     * @return \VoorraadApiV5\StructType\VoorraadInfoRecV5
     */
    public function setMagazijnen(\VoorraadApiV5\StructType\VoorraadInfoMagazijnTabV5 $magazijnen = null)
    {
        if (is_null($magazijnen) || (is_array($magazijnen) && empty($magazijnen))) {
            unset($this->magazijnen);
        } else {
            $this->magazijnen = $magazijnen;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\VoorraadInfoRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
