<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoorraadInfoMagazijnRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Vooraad informatie per magazijn
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class VoorraadInfoMagazijnRecV5 extends AbstractStructBase
{
    /**
     * The magazijnCode
     * Meta informations extracted from the WSDL
     * - documentation: de code van het magazijn
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $magazijnCode;
    /**
     * The voorraadTechnisch
     * Meta informations extracted from the WSDL
     * - documentation: Technische voorraad
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $voorraadTechnisch;
    /**
     * The voorraadEconomisch
     * Meta informations extracted from the WSDL
     * - documentation: Economische voorraad
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $voorraadEconomisch;
    /**
     * Constructor method for VoorraadInfoMagazijnRecV5
     * @uses VoorraadInfoMagazijnRecV5::setMagazijnCode()
     * @uses VoorraadInfoMagazijnRecV5::setVoorraadTechnisch()
     * @uses VoorraadInfoMagazijnRecV5::setVoorraadEconomisch()
     * @param string $magazijnCode
     * @param float $voorraadTechnisch
     * @param float $voorraadEconomisch
     */
    public function __construct($magazijnCode = null, $voorraadTechnisch = null, $voorraadEconomisch = null)
    {
        $this
            ->setMagazijnCode($magazijnCode)
            ->setVoorraadTechnisch($voorraadTechnisch)
            ->setVoorraadEconomisch($voorraadEconomisch);
    }
    /**
     * Get magazijnCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMagazijnCode()
    {
        return isset($this->magazijnCode) ? $this->magazijnCode : null;
    }
    /**
     * Set magazijnCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $magazijnCode
     * @return \VoorraadApiV5\StructType\VoorraadInfoMagazijnRecV5
     */
    public function setMagazijnCode($magazijnCode = null)
    {
        // validation for constraint: string
        if (!is_null($magazijnCode) && !is_string($magazijnCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($magazijnCode, true), gettype($magazijnCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($magazijnCode) && mb_strlen($magazijnCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($magazijnCode)), __LINE__);
        }
        if (is_null($magazijnCode) || (is_array($magazijnCode) && empty($magazijnCode))) {
            unset($this->magazijnCode);
        } else {
            $this->magazijnCode = $magazijnCode;
        }
        return $this;
    }
    /**
     * Get voorraadTechnisch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVoorraadTechnisch()
    {
        return isset($this->voorraadTechnisch) ? $this->voorraadTechnisch : null;
    }
    /**
     * Set voorraadTechnisch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $voorraadTechnisch
     * @return \VoorraadApiV5\StructType\VoorraadInfoMagazijnRecV5
     */
    public function setVoorraadTechnisch($voorraadTechnisch = null)
    {
        // validation for constraint: float
        if (!is_null($voorraadTechnisch) && !(is_float($voorraadTechnisch) || is_numeric($voorraadTechnisch))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($voorraadTechnisch, true), gettype($voorraadTechnisch)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($voorraadTechnisch) && mb_strlen(preg_replace('/(\D)/', '', $voorraadTechnisch)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($voorraadTechnisch, true), mb_strlen(preg_replace('/(\D)/', '', $voorraadTechnisch))), __LINE__);
        }
        if (is_null($voorraadTechnisch) || (is_array($voorraadTechnisch) && empty($voorraadTechnisch))) {
            unset($this->voorraadTechnisch);
        } else {
            $this->voorraadTechnisch = $voorraadTechnisch;
        }
        return $this;
    }
    /**
     * Get voorraadEconomisch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVoorraadEconomisch()
    {
        return isset($this->voorraadEconomisch) ? $this->voorraadEconomisch : null;
    }
    /**
     * Set voorraadEconomisch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $voorraadEconomisch
     * @return \VoorraadApiV5\StructType\VoorraadInfoMagazijnRecV5
     */
    public function setVoorraadEconomisch($voorraadEconomisch = null)
    {
        // validation for constraint: float
        if (!is_null($voorraadEconomisch) && !(is_float($voorraadEconomisch) || is_numeric($voorraadEconomisch))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($voorraadEconomisch, true), gettype($voorraadEconomisch)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($voorraadEconomisch) && mb_strlen(preg_replace('/(\D)/', '', $voorraadEconomisch)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($voorraadEconomisch, true), mb_strlen(preg_replace('/(\D)/', '', $voorraadEconomisch))), __LINE__);
        }
        if (is_null($voorraadEconomisch) || (is_array($voorraadEconomisch) && empty($voorraadEconomisch))) {
            unset($this->voorraadEconomisch);
        } else {
            $this->voorraadEconomisch = $voorraadEconomisch;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\VoorraadInfoMagazijnRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
